package com.engine.core;

import android.util.Log;

public class Debug 
{
    private static boolean mIsDebug = true;
    private static String mTag = "Engine";

    public static void enable()
    {
        mIsDebug = true;
    }

    public static void disable()
    {
        mIsDebug = false;
    }

    public static void setTag(String tag)
    {
        mTag = tag;
    }

    public static boolean getDebugStatus()
    {
        return mIsDebug;
    }

    public static void err(String scope, String msg)
    {
        if (!mIsDebug)
            return;

        Log.e(mTag, scope + ":" + msg);
    }

    public static void warn(String scope, String msg)
    {
        if (!mIsDebug)
            return;

        Log.w(mTag, scope + ":" + msg);
    }

    public static void inf(String scope, String msg)
    {
        if (!mIsDebug)
            return;

        Log.i(mTag, scope + ":" + msg);
    }

    public static void verb(String scope, String msg)
    {
        if (!mIsDebug)
            return;

        Log.v(mTag, scope + ":" + msg);
    }
}
