package com.engine.core;

import android.view.KeyEvent;
import android.view.MotionEvent;

public interface InputListener
{
    /**
     * Called when key down event happened.
     * 
     * @param keyCode
     * @param msg
     * @return
     */
    boolean onKeyDown(int keyCode, KeyEvent msg);

    /**
     * Called when key up event happened.
     * 
     * @param keyCode
     * @param msg
     * @return
     */
    boolean onKeyUp(int keyCode, KeyEvent msg); 

    /**
     * Called when touch event happened.
     * 
     * @param event
     * @return
     */
    boolean onTouchEvent(MotionEvent event);
}
