package com.engine.core;

import java.util.Comparator;

public class QuickSorter<Type> extends Sorter<Type>
{
    @Override
	protected void sort(Type[] array, int count, Comparator<Type> comparator)
    {
        quicksort(array, 0, count - 1, comparator);
    }
    
    public void quicksort(Type[] a, int left, int right, Comparator<Type> comparator)
    {
        if (right <= left) return;
        int i = partition(a, left, right, comparator);
        quicksort(a, left, i - 1, comparator);
        quicksort(a, i + 1, right, comparator);
    }
    
    private int partition(Type[] a, int left, int right, Comparator<Type> comparator)
    {
        int i = left-1;
        int j = right;
        while(true)
        {
            while(comparator.compare(a[++i], a[right]) < 0) {}
            while(comparator.compare(a[right], a[--j]) < 0)
                if(j == left)
                    break;
            if(i >= j)
                break;
            Type swap = a[i];
            a[i] = a[j];
            a[j] = swap;
        }
        Type swap = a[i];
        a[i] = a[right];
        a[right] = swap;
        return i;
    }
}
