package com.engine;

import java.io.IOException;


import com.engine.core.Debug;
import com.engine.core.Graphics;
import com.engine.resource.Resource;

import android.graphics.Bitmap;

public class Sprite
{
	/**
	 * Lista wszystkich sprajtw
	 */
	
	public static Sprite []list = null;
	
	/**
	 *  Identyfikator alokacji sprajta
	 */
	
	protected static int ID = 0;
	
	/**
	 * Wysoko obrazka
	 */
	
	public int width;
	
	/**
	 * Szeroko obrazka
	 */
	
	public int height;
	
	/**
	 * Origin x obrazka
	 */
	
	public int ox;
	
	/**
	 * Origin y obrazka
	 */
	
	public int oy;
	
	/**
	 * Ilo klatak obrazka
	 */
	
	public int count;
	
	/**
	 * Aktualna klatka obrazka
	 */
	
	public int image_index;
	
	/**
	 * klatki obrazka
	 */
	
	public static int _id = 0;
	
	private Bitmap texture[];
	
	Sprite()
	{
		init();
	}

	/**
	 * aduje obrazek z folderu assets.
	 * @param file_name nazwa pliku
	 * @throws IOException 
	 */
	
	public Sprite(String file_name) throws IOException
	{
		init();
		onCreate(file_name);
	}

	/**
	 * aduje obrazek i tworzy aninmacj.
	 * @param file_name
	 * @param count ilo klatek
	 * @param vert Ustala czy klatki s poziomo, czy pianowo.
	 */
	
	public Sprite(String file_name, int count)
	{
		init();
		onCreate(file_name, count, true);
	}

	/**
	 *  aduje obrazek i tworzy aninmacj.
	 * @param file_name nazwa pliku
	 * @param width szeroko
	 * @param height wysoko
	 * @param count ilo klatek
	 */
	
	public Sprite(String file_name, int count, boolean vert)
	{
		init();
		onCreate(file_name, count, false);
	}

	/**
	 *  aduje obrazek i tworzy aninmacj.
	 * @param file_name nazwa pliku
	 * @param width szeroko
	 * @param height wysoko
	 * @param count ilo klatek
	 * @throws IOException 
	 */
	
	public Sprite(String file_name, int width, int height, int count) throws IOException
	{
		init();
		onCreate(file_name, width, height, count);
	}
	
	/**
	 * Inicjowanie
	 */
	
	private void init()
	{
		width = 0;
		height = 0;
		count = 0;
		image_index = 0;
	}
	
	/**
	 * aduje pojedyczy obrazek z folderu assets.
	 * @param file_name nazwa pliku
	 * @throws IOException 
	 */
	
	public void onCreate(String file_name) throws IOException
	{
		texture = new Bitmap[1];
		texture[0] = Resource.GetBitmap(file_name);
		if(texture[0] == null)
			throw new IOException("File cannot find: "+file_name);
		width = texture[0].getWidth();
		height = texture[0].getHeight();
		this.count = 1;
	}
	
	/**
	 * aduje obrazek i tworzy aninmacj sprajta.
	 * @param file_name
	 * @param count ilo klatek
	 * @param vert Ustala czy klatki s poziomo, czy pianowo.
	 */
	
	public void onCreate(String file_name, int count, boolean vert)
	{
		texture = new Bitmap[count];
		Bitmap temp = null;
		try
		{
			temp = Resource.GetBitmap(file_name);
			if(temp.getWidth() == 0)
				throw new IOException("error: "+file_name);
		}catch(IOException e)
		{
			e.printStackTrace();
		}
		int _x = 0;
		if(vert)
		{
			int w = temp.getWidth()/count;
			int h = temp.getHeight();
			for(int i = 0; i<count; i++)
				texture[i] = Bitmap.createBitmap(temp, _x+(w*i), 0, w, h);
		}
		else
		{
			int w = temp.getWidth();
			int h = temp.getHeight()/count;
			for(int i = 0; i<count; i++)
				texture[i] = Bitmap.createBitmap(temp, 0, _x+(h*i), w, h);
		}
		width = texture[0].getWidth();
		height = texture[0].getHeight();
		this.count = count;
	}
	
	/**
	 *  aduje obrazek i tworzy aninmacj sprajta.
	 * @param file_name nazwa pliku
	 * @param width szeroko
	 * @param height wysoko
	 * @param count ilo klatek
	 * @throws IOException 
	 */
	
	public void onCreate(String file_name, int width, int height, int count) throws IOException
	{
		Bitmap temp = Resource.GetBitmap(file_name);
		int w = temp.getWidth();
		int h = temp.getHeight();
		int cx = w/width;
		int cy = h/height;
		texture = new Bitmap[count];
		for(int i = 0; i<cx; i++)
		{
			for(int j = 0; j<cy; j++)
			{
				texture[i+(j*cx)] = Bitmap.createBitmap(temp, i*width, j*height, width, height);
				if(i+(j*cx)>count)
					break;
			}
		}
		
		this.width = width;
		this.height = height;
		this.count = count;
	}
	
	/**
	 * Rysuje sprajta na ekranie
	 * @param g
	 * @param sprite_index index sprajta
	 * @param image_index klatka
	 * @param x wsprzdna x
	 * @param y wsprzdna y
	 */
	
	public static void draw(Graphics g, int sprite_index, int image_index, float x, float y)
	{
		if(list[sprite_index] == null)
		{
			Debug.warn("Sprite", "uncnow sprite: "+sprite_index);
		}
		_id = sprite_index;
		list[sprite_index].setFrame(image_index);
		list[sprite_index].onDraw(g, (int)x, (int)y);
	}
	
	public void onDraw(Graphics g, int x, int y)
	{
		if(texture[image_index] == null)
		{
			Debug.err("error: ", ""+_id);
			return;
		}
		g.drawBitmap(texture[image_index], x-ox, y-oy);
	}
	
	/**
	 * Pobiera szero sprajta
	 * @return szero
	 */
	
	public int getWidth()
	{
		return width;
	}

	/**
	 * Pobiera wysoko sprajta
	 * @return wysoko
	 */
	
	public int getHeight()
	{
		return height;
	}
	
	/**
	 * Pobiera szero sprajta
	 * @param sprite_index index sprajta
	 * @return szero
	 */
	
	public static int getWidth(int sprite_index)
	{
		return list[sprite_index].getWidth();
	}

	/**
	 * Pobiera wysoko sprajta
	 * @param sprite_index index sprajta
	 * @return wysoko
	 */
	
	public static int getHeight(int sprite_index)
	{
		return list[sprite_index].getHeight();
	}
	
	/**
	 * Pobiera ilo klatek
	 * @return ilo
	 */
	
	public int frameCound()
	{
		return count;
	}
	
	/**
	 * Pobiera ilo klatek
	 * @param sprite_index index obrazka
	 * @return ilo
	 */
	
	public static int frameCound(int sprite_index)
	{
		return list[sprite_index].frameCound();
	}
	
	/**
	 * Ustawia origin
	 * @param ox origin x
	 * @param oy origin y
	 */
	
	public void setOrigin(int ox, int oy)
	{
		this.ox = ox;
		this.oy = oy;
	}
	
	/**
	 * Ustawia origin na rodku sprajta
	 */
	
	public void setOriginCenter()
	{
		this.ox = width/2;
		this.oy = height/2;
	}
	/**
	 * 
	 * @param image_index klatka sprajta
	 */
	
	public void setFrame(int image_index)
	{
		if(image_index>count-1)
			image_index = 0;
		else if(image_index<0)
			image_index = count-1;
		this.image_index = image_index;
	}
	
	/**
	 * 
	 * @param sprite_index index sprajta
	 * @param image_index klatka
	 */
	
	public static void setFrame(int sprite_index, int image_index)
	{
		list[sprite_index].setFrame(image_index);
	}
	
	/**
	 * Tworzy pust list sprajtw
	 * @param sprite_count
	 */
	
	public static void allocate(int sprite_count)
	{
		ID  = 0;
		if(list != null)
			list = null;
		list = new Sprite[sprite_count];
	}
	
	public static void free()
	{
		//for(Bitmap b : texture)
			//b.recycle();
		//texture = null;
		list = null;
		ID = 0;
	}

	/**
	 * 
	 * @param file_name nazwa pliku
	 * @return identyfikator sprajta
	 * @throws IOException 
	 */
	
	public static int addSprite(String file_name) throws IOException
	{
		return addSprite(file_name, 0);
	}
	
	/**
	 * 
	 * @param file_name nazwa pliku
	 * @param count ilo klatek sprajta
	 * @return identyfikator sprajta
	 * @throws IOException 
	 */
	
	public static int addSprite(String file_name, int count) throws IOException
	{
		if(count != 0)
			Sprite.list[ID] = new Sprite(file_name, count);
		else 
			Sprite.list[ID] = new Sprite(file_name);
		return ID++;
	}
	
	/**
	 *  Dodaje sprzajta
	 * @param sprite Sprajt
	 * @return identyfikator sprajta
	 */
	
	public static int addSprite(Sprite sprite)
	{
		Sprite.list[ID] = sprite;
		return ID++;
	}
	
	public Bitmap getBitmap()
	{
		return texture[image_index];
	}
}
