package com.engine;

import com.engine.object.Object;

import android.graphics.Color;
import android.graphics.Paint.Align;

import com.engine.core.Fps;
import com.engine.core.Graphics;

final public class ShowFPS extends Object
{
	@Override
	public void onDraw(Graphics g)
	{
		g.setColor(Color.BLACK);
		g.setTextSize(19);
		g.getPaint().setAntiAlias(true);
		g.setTextBold(true);
		g.getPaint().setTextAlign(Align.LEFT);
	    String fps = "FPS: "+Fps.get();
	    g.drawText(fps, x+1, y+32);
	    g.getPaint().setAntiAlias(false);
	}
}
