package com.engine.action;

public abstract class Timer extends Action
{
	protected int timer;
	protected long tstart;
	protected boolean loop;
	
	public Timer()
	{
		init(-1, false);
	}
	
	public Timer(int timer)
	{
		init(timer, false);
	}
	
	public Timer(int timer, boolean loop)
	{
		init(timer, loop);
	}
	
	protected void init(int timer, boolean loop)
	{
		this.timer = timer;
		tstart = System.currentTimeMillis();
		this.loop = loop;
	}
	
	public void set(int time)
	{
		timer = time;
		tstart = System.currentTimeMillis();
	}
	
	public int get()
	{
		return timer;
	}
	
	public void setLoop(boolean loop)
	{
		this.loop = loop;
	}
	
	public boolean isLoop()
	{
		return loop;
	}
	
	@Override
	public void onStep()
	{
		if(timer != -1)
		{
			if(System.currentTimeMillis()-tstart>=timer)
			{
				onAction();
				if(loop)
					tstart = System.currentTimeMillis();
				else
				{
					timer = -1;
					destroy = true;
				}
			}
		}
	}
}
