package com.engine.resource;

import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Paint.Align;

import com.engine.core.Graphics;

public class DefauldLoadingScreen extends LoadingScreen
{
	public DefauldLoadingScreen(Resource sprite_factory)
	{
		super(sprite_factory);
	}
	
	@Override
	public void onCreate()
	{
		background("background.jpg");
		textColor(255, 0, 0, 0);
	}
	
	@Override
	public void onDraw(Graphics g)
	{
		if(bitmap != null)
			g.drawBitmap(bitmap, 0, 0);
		else
		{
			g.getPaint().setARGB(255, bcolor[0], bcolor[1], bcolor[2]);
			g.drawRect(new Rect(0, 0, g.getWidth(), g.getHeight()));
		}
		g.setTextBold(true);
		g.getPaint().setAntiAlias(true);
		g.setTextSize(getTextSize());
		g.getPaint().setTextAlign(Align.CENTER);
		g.getPaint().setARGB(tcolor[0], tcolor[1], tcolor[2], tcolor[3]);
		String str = "";
		if(isShowText())
			str = getLoadingText();
		if(isShowTextPercent())
			str += ""+res.getLoadingPercent()+"%";
		g.drawText(str, g.getWidth()/2, g.getHeight()-50);
		int size = g.getTextSize(str);
		float x = g.getWidth()/2-size/2;
		float y = g.getWidth()-50+getTextSize()+3;
		g.getCanvas().drawRoundRect(new RectF(x, y, x+size, y+5), 2.0f, 2.0f, g.getPaint());
		
		g.setColor(Color.BLACK);
		int state = (int) ((float) res.getLoadingPercent()*(float)(size/100.0f));
		g.getCanvas().drawRoundRect(new RectF(x, y, x+state, y+5), 2.0f, 2.0f, g.getPaint());
		g.getPaint().setAntiAlias(false);
	}
}
