package com.engine.action;

public abstract class Alarm extends Action
{
	protected int count;
	protected int max;
	
	public Alarm()
	{
		set(0);
	}

	public Alarm(int count)
	{
		set(count);
	}
	
	public void set(int count)
	{
		this.max = count;
		this.count = count;
	}
	
	public int get()
	{
		return this.count;
	}
	
	@Override
	public void onStep()
	{
		count--;
		if(count<0)
		{
			onAction();
			count = max;
		}
	}
}

