package com.engine.resource;

import java.io.IOException;

import android.graphics.Bitmap;

import com.engine.core.Graphics;

public abstract class LoadingScreen
{
	protected boolean text_show;
	protected boolean text_percent;
	protected String text_loading;
	protected Bitmap bitmap;
	protected int bcolor[] = new int[3];
	protected int tcolor[] = new int[4];
	protected int tsize;
	protected Resource res;
	
	public void showText(boolean show, boolean percent)
	{
		text_show = show;
		text_percent = percent;
	}
	
	public void loadingText(String text)
	{
		text_loading = text;
	}

	public void TextSize(int size)
	{
		tsize = size;
	}
	
	public int getTextSize()
	{
		return tsize;
	}
	
	public boolean isShowText()
	{
		return text_show;
	}

	public boolean isShowTextPercent()
	{
		return text_show;
	}
	
	public String getLoadingText()
	{
		return text_loading;
	}
	
	public void background(Bitmap image)
	{
		bitmap = image;
	}
	
	public void background(String file_name)
	{
		try
		{
			background(Resource.GetBitmap(file_name));
		} catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public void backgroundColor(int r, int g, int b)
	{
		bcolor[0] = r;
		bcolor[1] = g;
		bcolor[2] = b;
	}
	
	public void textColor(int a, int r, int g, int b)
	{
		tcolor[0] = a;
		tcolor[1] = r;
		tcolor[2] = g;
		tcolor[3] = b;
	}
	
	public LoadingScreen(Resource res)
	{
		this.res = res;
		tsize = 19;
		bitmap = null;
		showText(true, true);
		loadingText("Loading...");
		backgroundColor(0, 0, 0);
		textColor(255, 255, 255, 255);
	}
	
	public abstract void onCreate();
	
	public abstract void onDraw(Graphics g);
	
	public void onDestroy()
	{
		if(bitmap != null)
		{
			if(!bitmap.isRecycled())
				bitmap.recycle();
			bitmap = null;
		}
		bcolor = null;
		bcolor = null;
		text_loading = null;
	}
}
