package com.engine.core;

public class Fps
{
    private static final float mFrameLength = 1000.0f;

    private static long mLastTime;

    private static long mCurrentTime;

    /** Keeps number of frames passed in second. */
    private static long mFrames;

    private static long mElapsedTime;

    /** Keeps the actual fps. */
    private static float mFps;

    /**
     * Resets the variables needed for fps calculations.
     */
    public static void reset()
    {
        mLastTime = 0;
        mCurrentTime = 0;
        mFrames = 0;
        mElapsedTime = 0;
        mFps = 0;
    }

    /**
     * Updates time variables and calculates the current fps.
     */
    public static void update()
    {
        mFrames++;
        mCurrentTime = System.currentTimeMillis();
        mElapsedTime = mCurrentTime - mLastTime;
        if(mElapsedTime >= (long)mFrameLength)
        {
            mFps = ((float)mFrames * mFrameLength/(float)mElapsedTime);
            mFrames = 0;
            mLastTime = mCurrentTime;
        }
    }

    /**
     * Gets the number of actual frames per second.
     * @return Actual fps.
     */
    public static int get()
    {
        return (int)mFps;
    }

    /**
     * Gets the float number of actual frames per second.
     * @return Actual fps as float number.
     */
    public static float getF()
    {
        return mFps;
    }
}
