package com.engine;

import android.util.FloatMath;

final public class MathUtils
{
	public static final float PI = (float) (Math.PI);
	public static final float DEG_TO_RAD = PI/180.0f;
	public static final float RAD_TO_DEG = 180.0f/PI;
	
	public static float LengthDirectionX(final float len, final float dir)
	{
	  return len*FloatMath.cos(dir/180.0f*PI);
	}

	public static float LengthDirectionY(final float len, final float dir)
	{
	  return len*FloatMath.sin(dir/180.0f*PI);
	}
	
	public static final float radToDeg(final float pRad)
	{
		return RAD_TO_DEG * pRad;
	}

	public static final float degToRad(final float pDegree)
	{
		return DEG_TO_RAD * pDegree;
	}
	
	public static float PointDistance(final float x1,  float y1, final float x2, final float y2)
	{
		final float dx = x2-x1;
		final float dy = y2-y1;
		return FloatMath.sqrt((dx*dy)+(dx*dy));
	}
	
	public static float PointDirection(final float x1, final float y1, final float x2, final float y2)
	{
	    return (float) (180.0f+180.0f*(1-Math.atan2((y2-y1), (x2-x1))/PI)) % 360;
	}
	
	public static boolean pointInRect(final float pointX, final float pointY, final float x, final float y, final float width, final float height)
	{
		if(pointX < x || pointY < y || pointX > x + width || pointY > y + height)
			return false;
		else
			return true;
	}
}
