#Include once "windows.bi"
#include "TinyWeb.bi"

Function tWebCreate Cdecl Alias "tWebCreate"(parent As Double, x As Double, y As Double, w As Double, h As Double)As Double Export 
	hInstance=GetModuleHandle(NULL)
	hDll=LoadLibrary("atl.dll")
	If hDll Then
		Dim i As Integer
		AtlAxWinInit=Cast(Any ptr,GetProcAddress(hDll,"AtlAxWinInit"))
		AtlAxGetControl=Cast(Any ptr,GetProcAddress(hDll,"AtlAxGetControl"))
		If AtlAxWinInit()=0 Then
			Return AtlAxWinInit()
		EndIf		
		hWeb=CreateWindowEx(WS_EX_CLIENTEDGE,"AtlAxWin","about:blank",WS_CHILD Or WS_VISIBLE Or WS_VSCROLL Or WS_HSCROLL,x,y,w,h,CInt(parent),0,hInstance,0)
		AtlAxGetControl(hWeb,@pIUnknown)
		IUnknown=Peek(DWORD,pIUnknown)
		i=IUnknown->AddRef(pIUnknown)
		i=IUnknown->QueryInterface(pIUnknown,@IID_IWebBrowser,@pIWebBrowser)
		IWebBrowser=Peek(DWORD,pIWebBrowser)
		i=IWebBrowser->AddRef(pIWebBrowser)
		i=IUnknown->Release(pIUnknown)		
		hRect.left=x
		hRect.top=y
		hRect.right=w
		hRect.bottom=h
	else
		Return -1
	EndIf	
End Function

Function tWebGoTo Cdecl Alias "tWebGoTo"(url As ZString ptr)As Double Export 
	Dim wUrl As WString*260
	MultiByteToWideChar(CP_ACP,0,url,-1,@wUrl,260)
	Return IWebBrowser->Navigate(pIWebBrowser,@wUrl,NULL,NULL,NULL,NULL)		
End Function

Function tWebGoBack Cdecl Alias "tWebGoBack"() As Double Export 
	Return IWebBrowser->GoBack(pIWebBrowser)
End Function

Function tWebGoForward Cdecl Alias "tWebGoForward"() As Double Export 
	Return IWebBrowser->GoForward(pIWebBrowser)
End Function

Function tWebGoHome Cdecl Alias "tWebGoHome"() As Double Export 
	Return IWebBrowser->GoHome(pIWebBrowser)
End Function

Function tWebGoSearch Cdecl Alias "tWebGoSearch"() As Double Export 
	Return IWebBrowser->GoSearch(pIWebBrowser)
End Function

Function tWebRelease Cdecl Alias "tWebRelease"() As Double Export 
	IWebBrowser->Release(pIWebBrowser)
	DestroyWindow(hWeb)
	FreeLibrary(hDll)
End Function

Function tWebMove Cdecl Alias "tWebMove"(x As Double, y As Double) As Double Export
	hRect.left=x
	hRect.top=y
	Return MoveWindow(hWeb,x,y,hRect.right,hRect.bottom,TRUE)
End Function

Function tWebSize Cdecl Alias "tWebSize"(w As Double, h As Double) As Double Export
	hRect.right=w
	hRect.bottom=h
	Return MoveWindow(hWeb,hRect.left,hRect.top,w,h,TRUE)
End Function

'new
Function tWebShow Cdecl Alias "tWebShow"(show As Double) As Double Export 
	If show=0 then
		Return ShowWindow(hWeb,SW_HIDE)
	ElseIf show=1 then
		Return ShowWindow(hWeb,SW_SHOW)
	EndIf	
End Function

Function tWebRefresh Cdecl Alias "tWebRefresh"() As Double Export 
	Return IWebBrowser->Refresh(pIWebBrowser)
End Function