/* by Pieter (knobiks@gmail.com) */

#include "tcpparser.h"

TCPThread::TCPThread() {}

int TCPThread::StartServer()
{
    struct sockaddr_in srv;
    new_connection_mutex = PTHREAD_MUTEX_INITIALIZER; // mutex blokujacy

    // tworzymy socket TCP
    if( (listenfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror("Error['TCP']->CreateSocket\n"); // błąd tworzenia socketu
		exit(1);
	}

    // przypisujemy dane do serwera TCP
	srv.sin_family = AF_INET;
	srv.sin_addr.s_addr = INADDR_ANY;
	srv.sin_port = htons(TCP_PORT); // port na ktorym obslugujemy klientow

    // bindujemy (laczymy dane z naszym socketem)
	if( bind(listenfd, (struct sockaddr *) &srv, sizeof(srv)) < 0)
	{
		perror("Error['TCP']->Bind\n"); // blad polaczenia danych z socketem
		exit(1);
	}

    // przechodzimy w tryb nasluchiwania
    listen(listenfd, MAX_CLIENTS); // MAX_CLIENTS tu oznacza ile osób może czekac podczas obslugiwania 1 polaczenia.

    // tworzymy thread obslugi klientow
    pthread_create(&ThreadId, NULL, &TCPThread::EntryPointParser, (void *) this);

    // tworzymy thread do nasluchiwania klientow.
    pthread_create(&ThreadId, NULL, &TCPThread::EntryPointListner, (void *) this);

    return 0;
}

/*static */
void * TCPThread::EntryPointListner(void *pthis)
{
    TCPThread * oThis = (TCPThread*)pthis;
    oThis->RunListner();
}

void * TCPThread::EntryPointParser(void *pthis)
{
    TCPThread * oThis = (TCPThread*)pthis;
    oThis->RunParser();
}

/*reszta*/
int TCPThread::RunListner()
{
    // tu moze byc tez jakas konfiguracja przed utworzeniem threadu
    ExecuteListner(); // thread LISTNER wlasciwy
}

int TCPThread::RunParser()
{
    // tu moze byc tez jakas konfiguracja przed utworzeniem threadu
    ExecuteParser(); // thread PARSER wlasciwy
}

// thread LISTNER wlasciwy
void TCPThread::ExecuteListner()
{
    int clifd, cid;
    struct sockaddr_in cli;
    socklen_t laddr_len =  sizeof(cli);
    char ip[INET_ADDRSTRLEN];

    printf("[TCPThread] Listner thread executed!\n");

    while (1)
    {
        bzero(&cli, sizeof(cli)); // zerujemy klienta
        clifd = accept(listenfd, (struct sockaddr *) &cli, &laddr_len); // akceptujemy polaczenie
		NonBlockingMode(clifd);  // ustawiamy tryb nieblokujacy

        inet_ntop(AF_INET, &(cli.sin_addr), ip, INET_ADDRSTRLEN); // pobieranie adresu ip

		printf("[TCPThread] New Connection: %s:%d\n", ip, ntohs(cli.sin_port));

        pthread_mutex_lock(&new_connection_mutex); // blokujemy dostep do danych

        cid = Clients->Add(); // dodajemy nowego klienta i wstawiamy podstawowe dane
        Clients->Client[cid].Sock = clifd;
        Clients->Client[cid].IP.assign(ip);

        pthread_mutex_unlock(&new_connection_mutex); // inne thready moga juz korzystac z danych

    }
}

// thread PARSER wlasciwy
void TCPThread::ExecuteParser()
{
    int len, i;
    char temp[MAX_CLIENT_BUFFER];

    printf("[TCPThread] Parser thread executed!\n");

    memset((char *)temp, 0, MAX_CLIENT_BUFFER);

    while (1)
    {
        for ( i = 0 ; i < MAX_CLIENTS ; i++ )
        {
            if (Clients->Client[i].Sock != 0)
            {
                len = recv(Clients->Client[i].Sock, temp, MAX_CLIENT_BUFFER, 0);
                if (len == 0) // klient sie rozlaczyl
                {
                    printf("[TCPThread] Client %s disconnected (by peer)\n", Clients->Client[i].IP.c_str());

                    pthread_mutex_lock(&new_connection_mutex); // blokujemy dostep do danych
                    Clients->Delete(i); // usuwamy klienta ktory sie rozlaczyl
                    pthread_mutex_unlock(&new_connection_mutex); // inne thready moga juz korzystac z danych
                }
                else if (len < 0) // blad polaczenia czy cos. Klient traci polaczenie.
                {
                    if(errno != EAGAIN) // to nie jest blad braku odbioru
                    {
                        printf("[TCPThread] Client %s disconnected (by server & ERRNO: %d)\n", Clients->Client[i].IP.c_str(), errno);

                        pthread_mutex_lock(&new_connection_mutex); // blokujemy dostep do danych
                        Clients->Delete(i); // usuwamy klienta ktory sie rozlaczyl
                        pthread_mutex_unlock(&new_connection_mutex); // inne thready moga juz korzystac z danych
                    }
                }
                else // przyszedl pakiet i mozemy przetwarzac!
                {
                    ParsePacket(i, temp, len); // przetwarzamy pakiet
                }

                memset((char *)temp, 0, MAX_CLIENT_BUFFER); // resetujemy buffor
            }
        }
    }
}

void TCPThread::ParsePacket(int ClientID, char buffer[MAX_CLIENT_BUFFER], int length)
{
    CBuffer Pakiet;
    unsigned char PakietID;

    Pakiet.clear();
    Pakiet.addBuffer(buffer, length);

    Pakiet.readpos = 2; // 2 pierwsze bity to dlugosc pakietu.

    PakietID = Pakiet.readbyte();

    switch (PakietID)
    {
        case 11:
            Pakiet.clear();
            Pakiet.writebyte(11);
            Pakiet.writestring("dupa dupa cycki ;) mowilem ze zadziala!");
            send(Clients->Client[ClientID].Sock, Pakiet.data, Pakiet.BuffSize, 0);
        break;

        default:
            printf("Error['Unknown Packet Type']->PacketID: %d\n", PakietID);
        break;
    }


}

void TCPThread::NonBlockingMode(int sockfd)
{
	int opts;
	opts = fcntl(sockfd, F_GETFL);
	if(opts < 0)
	{
		perror("fcntl(F_GETFL)\n");
		exit(1);
	}
	opts = (opts | O_NONBLOCK);
	if(fcntl(sockfd, F_SETFL, opts) < 0)
	{
		perror("fcntl(F_SETFL)\n");
		exit(1);
	}
}
