/* by Pieter (knobiks@gmail.com) */

#ifndef CONSOLE_H_INCLUDED
#define CONSOLE_H_INCLUDED

#include "includes.h"

typedef void (*CMDVoid)(std::string arg[MAX_ARGUMENTS], int count);

struct CommandStruct {
    std::string cmd;
    std::string desc;
    CMDVoid func;
};

class Console {

    public:
        Console(); // kreator

        int AddCommand(CMDVoid func, std::string cmd, std::string desc);
        void ProcessAndExecute(std::string cmdline);
        int FindCommand(std::string cmd);
        std::string TrimArg(std::string s);
        std::string FillSpace(int length, int cnt);

        CommandStruct Commands[MAX_COMMANDS];
        int Count;
};

#endif // CONSOLE_H_INCLUDED
