/* by Pieter (knobiks@gmail.com) */

#include "console.h"

Console::Console()
{
    Count = 0;
}

int Console::FindCommand(std::string cmd)
{
    int i;
    for ( i = 0 ; i < MAX_COMMANDS ; i++ )
    {
        if (Commands[i].cmd == cmd)
        {
            return i;
        }
    }
    return -1;
}

int Console::AddCommand(CMDVoid func, std::string cmd, std::string desc)
{
    int i;

    for ( i = 0 ; i < MAX_COMMANDS ; i++ )
    {
        if (Commands[i].cmd == "")
        {
            Commands[i].func = func;
            Commands[i].cmd = cmd;
            Commands[i].desc = desc;
            Count++;
            return i;
        }
    }
    return -1;
}

void Console::ProcessAndExecute(std::string cmdline)
{
    char *argument, *line, *command, *tmp;
    std::string arg[MAX_ARGUMENTS];
    int argcount = 0;
    int index, i;

    for ( i = 0 ; i < MAX_ARGUMENTS ; i++ )
        arg[i] = "";

    line = (char*)cmdline.c_str();

    argument = strtok(line, " ");
    command = argument; // 1 argument to komenda

    while (argument != NULL)
    {
        argument = strtok(NULL, " ");
        if (argument != NULL)
        {
            arg[argcount].assign(argument);
            argcount++;
        }
    }

    index = 0;
    index = FindCommand(command);

    if (index > -1)
        Commands[index].func(arg, argcount);
    else
        printf("Command \"%s\" not found.\n", command);
}

std::string Console::TrimArg(std::string s)
{
    int position = s.find(" ");

    while ( position != std::string::npos )
    {
      s.replace( position, 1, "" );
      position = s.find(" ");
    }

    return s;
}

std::string Console::FillSpace(int length, int cnt)
{
    int i,max;
    std::string result = "";

    max = cnt - length;
    for ( i = 0 ; i < max ; i++ )
    {
        result = result + " ";
    }
    return result;
}

