<?php
/*
+--------------------------------------------------------------------------
|	Language Converter v0.1
|	Autor: Ranma_man
|	Copyright (C) 2004
+---------------------------------------------------------------------------
*/



//---------------------------------
// Krok 1: Rozpocznij zapis logu
//---------------------------------

$log = fopen ( 'log.txt' , 'w' );

flock ( $log , 2 );
fwrite ( $log , 'Rozpoczcie konwersji tumaczenia. Data: '.date('H:i - j.m.Y',time())."\n" );



//---------------------------------
// Krok 2: Sprawd czy s katalogi
//---------------------------------

$root = getcwd();

$current_dir = opendir ( $root );

$dir	=	array();
$dir_	=	array ( 'old' , 'new' , 'mixed' );

while ( $resource = readdir ( $current_dir ) )
{
	if ( @is_dir ( $resource ) )
	{
		if ( $resource <> '.' && $resource <> '..' )
		{
			$dir[] = $resource;
		}
	}
}

closedir ( $current_dir );

foreach ( $dir_ as $v )
{
	if ( !in_array ( $v , $dir ) )
	{
		fwrite ( $log , '<span class="e">Error: Brak katologu "'.$v.'"!</span>'."\n".'<span class="e">Error: Zakoczenie konwersji z bdem!</span>' );
		make_end();
	}
}

unset ( $dir_ );
unset ( $dir );



//---------------------------------
// Krok 3: Pobierz zawartosc kat.
//---------------------------------

$new_temp = array();
$old_temp = array();
$not_converted = array();
$must_be_converted = array();

$new = array();
$old = array();

$current_dir = opendir ( $root.'/new' );

while ( $file = readdir ( $current_dir ) )
{
	if ( !@is_dir ( $file ) )
	{
		$new_temp[] = $file;
	}
}

closedir ( $current_dir );
sort ( $new_temp );

fwrite ( $log , '<span class="n">Liczba plikw skadowych nowego tumaczenia - <span class="b">'.count($new_temp)."</span></span>\n" );

$current_dir = opendir($root.'/old');

while ( $file = readdir ( $current_dir ) )
{
	if ( !@is_dir ( $file ) )
	{
		$old_temp[] = $file;
	}
}

closedir ( $current_dir );
sort ( $old_temp );

fwrite ( $log , '<span class="n">Liczba plikw skadowych starego tumaczenia - <span class="b">'.count($old_temp)."</span></span>\n" );



//---------------------------------
// Krok 4: Porownaj pliki
//---------------------------------

fwrite ( $log , "\nLista plikw starego tumaczenia, w tym nie majce odpowiednikw w nowym:\n" );

foreach ( $old_temp as $v )
{
	if ( !in_array ( $v , $new_temp ) )
	{
		fwrite ( $log , '<span class="e">'.$v."</span>\n" );
	}
	else
	{
		$old[$v] = '';
	}
}

fwrite ( $log , "Koniec listy\n" );

fwrite ( $log , "\nLista plikw nowego tumaczenia,  w tym nie majce odpowiednikw w starym:\n" );

foreach ( $new_temp as $v )
{
	if ( !in_array ( $v , $old_temp ) )
	{
		fwrite ( $log , '<span class="e">'.$v."</span>\n" );
		$not_converted[] = $v;
	}
	else
	{
		fwrite ( $log , '<span class="z">'.$v."</span>\n" );
		$new[$v] = '';
	}
}
fwrite ( $log , 'Koniec listy'."\n" );

unset ( $old_temp );
unset ( $new_temp );



//---------------------------------
// Krok 5: Buduj nowe pliki
//---------------------------------

fwrite ( $log , "\nRozpoczcie tumaczenia:\n" );

foreach ( $new as $k => $v )
{
	include( 'new/'.$k );
	$new_vars = $lang;
	unset ( $lang );

	include( 'old/'.$k );
	$old_vars = $lang;
	unset ( $lang );

	fwrite ( $log , "\n".'Plik: <span class="b">'.$k."</span>\n" );

	if ( count ( $new_vars ) == count ( $old_vars ) )
	{
		fwrite ( $log , '<span class="z">Indeksw nowych: '.count($new_vars).' Indeksw starych: '.count ($old_vars)."</span>\n" );
	}
	else
	{
		fwrite ( $log , '<span class="e">Indeksw nowych: '.count($new_vars).' Indeksw starych: '.count ($old_vars)."</span>\n" );
	}

	$n = 0;

	$bad_temp = array();
	$good_temp = array();

	foreach ( $new_vars as $k2 => $v2 )
	{
		if ( array_key_exists ( $k2 , $old_vars ) )
		{
			$good_temp[$k2] = $old_vars[$k2];
		}
		else
		{
			$bad_temp[$k2] = $v2;
			$n++;
		}
	}

	if ( $n == 0 )
	{
		fwrite ( $log , '<span class="z">Wszystkie indeksy z new zostay znalezione w old!</span>'."\n" );
		fwrite ( $log , '<span class="z">Wszystkie indeksy tego pliku przetumaczone!</span>'."\n" );
	}
	else
	{
		fwrite ( $log , '<span class="e">Liczba nieznalezionych indeksw new w old: '.$n."</span>\n" );
		fwrite ( $log , '<span class="y">Znalezione indeksy zostay przetumaczone.</span>'."\n" );
	}
	unset ( $n );

	if ( count ( $bad_temp ) > 0 )
	{
		$bad_temp['\'"converter_kk"\''] = '';
		$must_be_converted[$k] = array ( $k , count ( $bad_temp ) );
	}

	$mixed_temp = array_merge ( $bad_temp , $good_temp );

	$mixed_file = fopen ( 'mixed/'.$k , 'w' );
	flock ( $mixed_file , 2 );
	fwrite ( $mixed_file , "<?php\n\n\$lang = array (\n\n" );

	foreach ( $mixed_temp as $k2 => $v2 )
	{
		if ( $k2 <> '\'"converter_kk"\'' )
		{
			fwrite ( $mixed_file , '\''.$k2.'\'			=>	"'.str_replace( '"' , '\"' , $v2 )."\",\n");
		}
		else
		{
			fwrite ( $mixed_file , "\n// Language Converter: Koniec niezkonwenterowanych indeksow \n\n");
		}
	}

	fwrite ( $mixed_file , "\n);\n?>" );
	flock ( $mixed_file , 3 );
	fclose ( $mixed_file );

	unset ( $new_vars );
	unset ( $old_vars );
	unset ( $bad_temp );
	unset ( $good_temp );
	unset ( $mixed_temp );
}



//---------------------------------
// Krok 6: Reszta
//---------------------------------

fwrite ( $log , "\nKoniec tumaczenia\n\nPliki, ktre nie zostay przetumaczone (tylko kopia nowego pliku):\n" );

$file = '';
foreach ( $not_converted as $v )
{
	fwrite ( $log , '<span class="b">'.$v."</span>\n" );

	$file = file ( $root.'/new/'.$v);

	$mixed_file = fopen ( 'mixed/'.$v , 'w' );
	flock ( $mixed_file , 2 );

	foreach ( $file as $v2 )
	{
		fwrite ( $mixed_file , $v2 );
	}

	flock ( $mixed_file , 3 );
	fclose ( $mixed_file );
	unset ( $file );
}

fwrite ( $log , "\nPliki czciowo przetumaczone:\n" );


foreach ( $must_be_converted as $v )
{
	fwrite ( $log , '<span class="b">'.$v[0]."</span> - indeksw nieprzetumaczonych: ".$v[1]."\n" );
}

fwrite ( $log , "\nINDEKSY NIEPRZETUMACZONE ZNAJDUJ SI ZAWSZE NA POCZTKU PLIKW!\n" );
fwrite ( $log , 'Link do tego logu: <a href="log.html">Kliknij tutaj!</a>' );

make_end();


function make_end()
{
	global $log;

	flock ( $log , 3 );
	fclose ( $log );

	$log = file ( 'log.txt' );

	$new_log = '<?xml version="1.0" encoding="iso-8859-2"?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><title>Language Converter v0.1</title><meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" /><meta http-equiv="Content-Language" content="pl" /><meta content="ukasz S. - Ranma_man" name="Author" /><style type="text/css" media="all">.e { background-color: #FFDDDD; margin-top: 1px; line-height: 15px; width: 50%; } .n { background-color: #EEEEFF; margin-top: 1px; line-height: 15px; width: 50%; } .z { background-color: #EEFFEE; margin-top: 1px; line-height: 15px; width: 50%; } .b {font-weight: bold; } .y { background-color: #FFFFEE; margin-top: 1px; line-height: 15px; width: 50%; } .b {font-weight: bold; }</style></head><body style="font-family: verdana; font-size: 11px; line-height: 16px;">';
	
	$i = 1;

	foreach ( $log as $v )
	{
		$new_log .= $i.') '.nl2br($v);
		$i++;
	}
	$new_log .= '</body></html>';

	$new_log_file = fopen ( 'log.html' , 'w' );
	flock ( $new_log_file , 2 );
	fwrite ( $new_log_file , $new_log );
	flock ( $new_log_file , 3 );
	fclose ( $new_log_file );
	echo $new_log;
	die();
}
?>