#define bullnet_init
//Init the bullnet system
//arg0:low port
//arg1:hight port
//arg2:mode (0:Lan,1:Local)
//create a netmoniter
var onetmon;
onetmon=object_add();//net moniter object
object_set_visible(onetmon,0);
object_set_persistent(onetmon,1);
object_event_add(onetmon,ev_step,ev_step_normal,"netmonstep();");
object_event_add(onetmon,ev_alarm,0,"findserver();");
global._netmon=instance_create(-1,-1,onetmon);

global._onewplayer=object_add();//new player object;
global._oplayer=object_add();
object_event_add(global._onewplayer,ev_step,ev_step_normal,"newplayerstep();");
object_event_add(global._onewplayer,ev_alarm,0,"closesocket(sock);instance_destroy();");

global._playerdata=ds_map_create();
//message id
global._avatar=255;
global._changeplayer=254;
global._lobbymsg=253;
global._findgamemsg=252;
global._foundmsg=251;
global._joinmsg=250;
global._acceptmsg=249;
global._declinemsg=248;
global._state=0;//0:lobby,1:host,2:join
global.serverlist[0,0]=0;
global.servercount=0;
//settings
global._interval=120; //update interval
//getting arguments
global._low=argument0;
global._high=argument1;
global._mode=argument2;//0:Lan,1:local,2:internet(not supported yet)

//server list,message queue
global._msgqueue=ds_queue_create();//chat queue
//setting up socket
var i;
for(i=global._low;i<=global._high;i+=1)
 {
 global._clientudp=udpconnect(i,1);
 if global._clientudp>0 break;
 }
global._clientudpport=i;

//broadcast setting
getip();
switch(global._mode)
 {
 case 0:ds_list_delete(global.iplist,ds_list_find_index(global.iplist,'127.255.255.255'));break;
 case 1:ds_list_clear(global.iplist);ds_list_add(global.iplist,'127.0.0.1');break;
 }

if global._clientudp
 global._netmon.alarm[0]=1;//start finding for server
return global._clientudp;
#define bullnet_deinit
var onetmon;
onetmon=global._netmon.object_index;
if global._state>0 session_end();
with global._netmon instance_destroy();
object_delete(onetmon);
ds_list_destroy(global.iplist);
ds_queue_destroy(global._msgqueue);
closesocket(global._clientudp);
#define lobbysend
//arg0: lobby/global chat message to send
clearbuffer();
writebyte(global._lobbymsg);
writestring(argument0,true);
broadcast();
#define lobbyget
//return global/lobby chat message, return '' if none found
if ds_queue_size(global._msgqueue)>0
 return ds_queue_dequeue(global._msgqueue)
else
 return '';
 
#define session_status
return global._state;//0:lobby,1:host,2:join
#define session_create
//start hosting a session
//arg0:Max amount of people allowed to be in the connected but not accepted list
//arg1:Max players,0 for infinite
//arg2:Player name
//ar3:True if dedicated
if global._state>0 return false;
var me,name,playerid,i;
global._dedicated=argument3;
for(i=global._low;i<=global._high;i+=1)
 {
 global._servertcp=tcplisten(i,argument0,1);
 if global._servertcp>0 break;
 }
global._servertcpport=i;
if global._servertcp
 {
 global.maxplayer=argument1;
 global._netmon.alarm[0]=-1;//stop looking for session
 global._state=1;

 if !argument3
  {
  global._clienttcp=tcpconnect('127.0.0.1',global._servertcpport,1);
  setnagle(global._clienttcp,1);
  me=tcpaccept(global._servertcp,1);
  setnagle(me,1);
  name=argument2;
  global.myid=1;
  var _myself;_myself=instance_create(-1,-1,global._oplayer);
  _myself.name=name;
  _myself.sock=me;
  _myself.myid=1;
  ds_map_add(global._playerdata,global.myid,_myself);
  }
 }
return global._servertcp;
#define session_end
//stop hosting the session
//not tested
if global._state==0 return false;
global._netmon.alarm[0]=1;
message_begin();
writebyte(0);//buh bye
message_send(0,global._changeplayer);
if global._state==1
 {
 closesocket(global._servertcp);
 with(global._oplayer)
  instance_destroy();
 }
ds_map_clear(global._playerdata);
global._state=0;
global._servertcp=0;
global._clienttcp=0;
return true;
#define session_join
//arg0:server id
//arg1:timeout
//arg2:player name
//return successful or not
if global._state>0 return false;
if global.servercount<(argument0+1) return false;
global._clienttcp=tcpconnect(global.serverlist[argument0,0],global.serverlist[argument0,1],1);
if global._clienttcp
 {
 clearbuffer();
 writebyte(global._joinmsg);
 writestring(argument2,1);
 sendmessage(global._clienttcp);
 var time;
 time=current_time;
 while (current_time-time)<argument1 and tcpconnected(global._clienttcp)
  if receivemessage(global._clienttcp) //only read if received message
   {
   if readbyte()==global._acceptmsg
    {
    setnagle(global._clienttcp,1);
    global.myid=readushort();
    global._netmon.alarm[0]=-1;//stop looking for session
    global._state=2;
    message_begin();
    writebyte(1);//add player
    writestring(argument2,1);
    message_send(0,global._changeplayer);
    _player=instance_create(-1,-1,global._oplayer);
    _player.name=argument2;
    _player.myid=global.myid;
    ds_map_add(global._playerdata,global.myid,_player);
    return true;
    }
   else
    {
    closesocket(global._clienttcp);//rejected
    return false;
    }
   }
 //disconnected or time out
 closesocket(global._clienttcp);
 return false;
 }
closesocket(global._clienttcp);
return false;//can't connect
#define session_join_ip
//arg0:server ip:port
//arg1:timeout
//arg2:player name
//return successful or not
if global._state>0 return false;
if global.servercount<(argument0+1) return false;
global._clienttcp=tcpconnect(string_field(argument0,1,':'),string_field(argument0,2,':'),1);
if global._clienttcp
 {
 clearbuffer();
 writebyte(global._joinmsg);
 writestring(argument2,1);
 sendmessage(global._clienttcp);
 var time;
 time=current_time;
 while (current_time-time)<argument1 and tcpconnected(global._clienttcp)
  if receivemessage(global._clienttcp) //only read if received message
   {
   if readbyte()==global._acceptmsg
    {
    setnagle(global._clienttcp,1);
    global.myid=readushort();
    global._netmon.alarm[0]=-1;//stop looking for session
    global._state=2;
    message_begin();
    writebyte(1);//add player
    writestring(argument2,1);
    message_send(0,global._changeplayer);
    _player=instance_create(-1,-1,global._oplayer);
    _player.name=argument2;
    _player.myid=global.myid;
    ds_map_add(global._playerdata,global.myid,_player);
    return true;
    }
   else
    {
    closesocket(global._clienttcp);//rejected
    return false;
    }
   }
 //disconnected or time out
 closesocket(global._clienttcp);
 return false;
 }
closesocket(global._clienttcp);
return false;//can't connect
#define string_field
//stringfield(string,index,seperator)
var i,ret,maxl,ch,p;
i = 1;
ret = "";
argument0 += argument2;

maxl = string_length(argument0);
for (p=1; p<=maxl; p+=1)
   {
   ch = string_char_at(argument0, p);
   if ch = argument2
       {
       if i=argument1
           return ret;
       ret = "";
       i += 1;
       }
   else
       ret += ch;
   }
#define getip
//please don't touch this
//getting the broadcasting address in a weird way 'cause 39 can not use 255.255.255.255
//wtf?
var excall,list,ip,i,head,addr,choice,data;
global.iplist=ds_list_create();
excall=external_define('getip.dll','getip',dll_stdcall,ty_string,0);
list=external_call(excall);
external_free('getip.dll');
for(i=1;i<=string_count(';',list)+1;i+=1)
 {
 ip=string_field(list,i,';');//get the first ip
 addr[0]=string_field(ip,1,'.')+'.255.255.255';
 addr[1]=string_field(ip,1,'.')+'.'+string_field(ip,2,'.')+'.255.255';
 addr[2]=string_field(ip,1,'.')+'.'+string_field(ip,2,'.')+'.'+string_field(ip,3,'.')+'.255';
 for(j=0;j<=2;j+=1)
  {
  clearbuffer();
  writeuint(game_id);
  writebyte(j);
  sendmessage(global._clientudp,debug(addr[j]),global._clientudpport);
  }
 sleep(300);
 choice=2;
 while(receivemessage(global._clientudp))
  if readuint()=game_id
   {
   data=readbyte();
   if data>=0 and data<choice
    choice=data;
   }
 ds_list_add(global.iplist,addr[choice]);
 }
//show_message(ds_list_find_value(global.iplist,0));
//game_end();
#define findserver
//please don't touch this
global.servercount=0;
clearbuffer();
writebyte(global._findgamemsg);
writeuint(game_id);
writeushort(global._clientudpport);
broadcast();
alarm[0]=global._interval;
#define netmonstep
//please don't touch this
while receivemessage(global._clientudp)
 {
 switch readbyte()
  {
  case global._lobbymsg:if global._state==0 ds_queue_enqueue(global._msgqueue,readstring());break;
  case global._findgamemsg:
   if (global._state==1)and(readuint()==game_id)
    {
    var otherport;
    otherport=readushort();
    clearbuffer();
    writebyte(global._foundmsg);
    writeushort(global._servertcpport);
    writeExtraInfo();//custom info
    sendmessage(global._clientudp,lastip(),otherport);
    }
  break;
  case global._foundmsg:
    global.serverlist[global.servercount,0]=lastip();
    global.serverlist[global.servercount,1]=readushort();
    readExtraInfo();//read the custom info
    global.servercount+=1;
    global._netmon.alarm[0]=global._interval;//delay the reset time
  break;
  }
 }

if global._state!=1 exit;
//hosting part
//checking for new player
_player=tcpaccept(global._servertcp,1); //if a player connects
if _player>0
 {
 if (ds_map_size(global._playerdata)<global.maxplayer)or(global.maxplayer==0)
  {
  _playeri=instance_create(-1,-1,global._onewplayer);//let an instance handle the new player
  setnagle(_player,1);
  _playeri.sock=_player;
  _playeri.alarm[0]=room_speed*2;
  }
 else
  {
  clearbuffer();
  writebyte(global._declinemsg);
  sendmessage(_player);
  closesocket(_player);
  }
 }

//message part
debug(instance_number(global._oplayer));
with global._oplayer
 while receivemessage(sock)
  {
  msgid=readbyte();
  receiver=readushort();
  setpos(1);
  writeushort(myid);//write the sender's id
  if receiver==0 //to all player
   {
   with global._oplayer
    if myid!=other.myid //don't send the sender his own message :P
     sendmessage(sock); 
   }
   else
    sendmessage(ds_map_find_value(global._playerdata,receiver).sock);//forward the message
  if (msgid==global._changeplayer)and global._dedicated
   {
   setpos(3);
   if readbyte()==0
    {
    _player=ds_map_find_value(global._playerdata,myid);
    ds_map_delete(global._playerdata,myid);
    with _player
     instance_destroy();
    }
   }
  }
 
#define broadcast
//broadcast the buffer content
var i,j;
for(i=global._low;i<=global._high;i+=1)
 {
 if !((global._mode=1)and(global._clientudpport=i))
  for(j=0;j<ds_list_size(global.iplist);j+=1)
  sendmessage(global._clientudp,ds_list_find_value(global.iplist,j),i);
 }
#define newplayerstep
//please don't touch this
//server only
var _name,playerid;
if receivemessage(sock)
 if readbyte()==global._joinmsg
  {
  _name=readstring();
  playerid=2;
  //find a new id
  while ds_map_exists(global._playerdata,playerid) playerid+=1;
  clearbuffer();
  writebyte(global._acceptmsg);
  writeushort(playerid);
  sendmessage(sock);

  clearbuffer();
  writebyte(global._changeplayer);
  with global._oplayer
   {
   setpos(1);
   writeushort(myid);
   writebyte(1);
   writestring(name,1);
   sendmessage(other.sock);
   }
  _player=instance_create(-1,-1,global._oplayer);
  _player.name=_name;
  _player.myid=playerid;
  _player.sock=sock;
  ds_map_add(global._playerdata,playerid,_player);
  instance_destroy();
  }
#define message_send
//arg0:receiver(either name or id) ,0 to send to all
//arg1:id
if global._state==0 return false;
var receiver,key,i,size;
if is_string(argument0) //if we use player's name
 {
 receiver=-1;
 with global._oplayer
  if name=argument0
   {
   other.receiver=myid;
   break;
   }
 if receiver=-1 //if can't find the player id
  return false;
 }
else
 receiver=argument0;//if we use id
setpos(0);//write message header
writebyte(argument1);
writeushort(receiver);
return sendmessage(global._clienttcp);
#define message_player
//return the sender of the last received message
if global._state==0 return false;
return global._sender;
#define message_begin
if global._state==0 return false;
clearbuffer();
writebyte();writeshort();//3 bytes for header
#define message_id
//return the id of the last message
if global._state==0 return false;
return global._msgid;
#define message_receive
if global._state==0 return false;
do
{
if receivemessage(global._clienttcp)
 {
 global._msgid=readbyte();
 global._sender=readushort();
 if global._msgid==global._changeplayer
  {
  if readbyte()
   {
   var name,_player;
   name=readstring();
   if global._state==2
    {
    _player=instance_create(-1,-1,global._oplayer);
    _player.name=name;
    _player.myid=global._sender;
    ds_map_add(global._playerdata,global._sender,_player);
    }
   onPlayerJoin(global._sender,name);
   }
  else
   {
   var name,_player;
   _player=ds_map_find_value(global._playerdata,global._sender);
   name=_player.name;
   with _player
    instance_destroy();
   ds_map_delete(global._playerdata,global._sender);
   onPlayerLeave(global._sender,name);
   }
  continue;
  }
 if global._msgid==global._avatar
  {//nothing yet
  continue;
  }
 return bytesleft();
 }
else
 break;
}
until (global._msgid != global._changeplayer)or(global._msgid != global._avatar);
return false;
#define writeExtraInfo
//this code can be modified
writestring(global.name,1);
#define readExtraInfo
//this script can be modified
global.serverlist[global.servercount,2]=readstring();
#define onPlayerJoin
//called when a player joins, arg0:id, arg1:name, do anything you want
var i;
debug("new player");
i=instance_create(0,0,otherplayer);
i.myid=debug(argument0);
i.name=debug(argument1);
#define onPlayerLeave
//called when a player leaves,arg0:id,arg1: name ,do anything you want
with otherplayer
 if myid==argument0 
  instance_destroy();
#define player_id
//arg0:player name
//return player id or 0 if can't find any
if global._state==0 return false;
with global._oplayer
 if name==argument0
  return myid;
return 0
#define player_name
//arg0:player id
//return: player name or '' if can't find
if global._state==0 return '';
if ds_map_exists(global._playerdata,argument0)
 return ds_map_find_value(global._playerdata,argument0).name
else
 return '';
#define player_number
//return number of players
if global._state==0 return false;
return ds_map_size(global._playerdata);
#define debug
//this is not a part of bullnet,used for debug purpose,you will find this very handy
show_debug_message(string(argument0));
return argument0;

