#include <stdio.h>
#define ROZM 100
#define PLIK "lista.txt"

struct kontakt					// struktura z danymi osob
{
	char nazwisko[20];
	char imie[20];
	int numer;
};

int ilosc=0; 					// okresla ile osob jest w ksiazce
struct kontakt *wykaz[ROZM];	//wskazniki na struktury kontakt
FILE *plikWykazu; 				// wskaznik na plik do zapisu/odczytu

// funkcja wyswietla napis "wcisnij enter" na ekranie

void czekaj()
{
	
	printf("\n > Wcisnij ENTER"); 
	getchar();
}


// SORTOWANIE WG NAZWISKA
void rozstaw(int skad)
{
        int i;
        if (ilosc  == skad) return;

        for (i=ilosc; i>=skad; i--)
        {
                wykaz[i] = wykaz[i-1];
        }
}

void duzaLitera(char *litera)
{
     if ( *litera > 90 ) *litera -=32;
 }

int sortNazwisko (struct kontakt *o) {
             int i=0;
             
             while(i<ilosc)
             {
                           if ( strcmp( wykaz[i]->nazwisko, o->nazwisko ) > 0 )
                           {
                                return i;
                           }
                           else if ( strcmp( wykaz[i]->nazwisko, o->nazwisko ) == 0 )
                           {
                                if ( strcmp( wykaz[i]->imie, o->imie ) > 0 )
                                {
                                   return i;
                                }     
                           }
                           i++;
             }
             
             return ilosc;
}

// ODCZYT Z PLIKU


void czytaj()
{
	int i=0,gdzie;
	struct kontakt o;
	
	plikWykazu=fopen(PLIK,"r");
	
	if (plikWykazu==NULL)
	{
    	printf("Blad odczytu pliku");
    	return;
	}
	
	// przeczesz w petli kontakty tak dlugo, az cos jest w pliku
	// lub i przekroczy rozmiar tablicy *wykaz[]
	// wstawiamy od pozycji 0, zatem poprzednie wpisy beda skasowane o ile istnialy - zawsze mozna je najpiew zapisac :)

	while ( ilosc<ROZM && fscanf(plikWykazu,"%s%s%d",o.nazwisko, o.imie, &o.numer)!=EOF)
	{
    	duzaLitera(&o.nazwisko[0]);
        duzaLitera(&o.imie[0]);
        gdzie = sortNazwisko( &o );
    	rozstaw( gdzie );
        
        
        wykaz[gdzie]=(struct kontakt *)malloc(sizeof(struct kontakt));
    	strcpy(wykaz[gdzie]->nazwisko,o.nazwisko);
    	strcpy(wykaz[gdzie]->imie,o.imie);
    	wykaz[gdzie]->numer=o.numer;
    	ilosc++;
	}
	
	// ustal ilosc wpisow
	printf("\n\n > Przeczytano %d kontaktow z pliku\n",ilosc);
	czekaj();
}


// ZAPIS DO PLIKU


void zapisz()
{
	int i;

    plikWykazu = fopen(PLIK,"w");
    
    // zapisz w petli do pliku
    
    for(i=0; i<ilosc; i++)
    {
        fprintf(plikWykazu,"%s\n",wykaz[i]->nazwisko);
        fprintf(plikWykazu,"%s\n",wykaz[i]->imie);
        fprintf(plikWykazu,"%i\n",wykaz[i]->numer);
    }
    fclose(plikWykazu);
	
	printf("\n\n > Kontakty zapisane do pliku\n");
	czekaj();
}

// DRUKOWANIE


void drukujJeden(int jaki)
{	
	printf(" %s %s\t\t %i\n",wykaz[jaki]->nazwisko,wykaz[jaki]->imie, wykaz[jaki]->numer);
}

void drukuj()
{
	printf("%i",ilosc);
	
	int i=0;
	printf("\n\n Nazwisko i imie \t Numer\n ");
	while(i++<50) printf("-");
	printf("\n");
	for (i=0; i<ilosc; i++)
	{
			drukujJeden(i);
	}
	czekaj();
}


// WSTAWIANIE


void wstaw() // wstawia nowy kontakt na pozycje 0
{
	struct kontakt o;
	int i=0;
	
	// pobierz dane od uzytkownika

	printf("Podaj imie:");
	scanf("%s",&o.imie);
	
	printf("Podaj nazwisko:");
	scanf("%s",&o.nazwisko);
	
	printf("Podaj numer (bez - ):");
	scanf("%i",&o.numer);

	//wstawianie
	
	duzaLitera(&o.nazwisko[0]);
    duzaLitera(&o.imie[0]);

    int gdzie;
	gdzie = sortNazwisko( &o );
    rozstaw( gdzie );
        
        
    wykaz[gdzie]=(struct kontakt *)malloc(sizeof(struct kontakt));
    strcpy(wykaz[gdzie]->nazwisko,o.nazwisko);
    strcpy(wykaz[gdzie]->imie,o.imie);
    wykaz[gdzie]->numer=o.numer;
    ilosc ++;	
	//podsumuj

	printf("\nDodano: %s %s, numer: %i\n", o.nazwisko, o.imie, o.numer);
	czekaj();
}

// SZUKANIE


void szukajKoniec(int ile) //jezeli ile = 0, pokazuje komunikat, ze nic nie znaleziono
{
	if (ile == 0)
	{
		printf("\n Niestety, nic nie znaleziono\n");
	}
	czekaj();
}

// SZUKANIE NAZWISKA

void szukajNazwiska() // szuka osoby o podanym nazwisku
{
	char nazw[20];
	int i=0,ile=0;

	printf("\n Podaj nazwisko: ");
	scanf("%s",&nazw);
	getchar();

	for (i=0; i<ilosc; i++)
	{	
		if ( strcmp( wykaz[i]->nazwisko , nazw ) == 0 ) // sprawdz czy nie ma roznic pomiedzy nazwami
		{
			drukujJeden(i);
			ile++;
		}
	}
	szukajKoniec(ile); //jezeli bylo 0 znalezionych, bedzie pokazana informacja
}

// SZUKANIE IMIENIA

void szukajImienia() // szuka osoby o podanym imieniu
{
	char imie[20];
	int i=0,ile=0;

	printf("\n Podaj imie: ");
	scanf("%s",&imie);
	getchar();

	for (i=0; i<ilosc; i++)
	{	
		if ( strcmp( wykaz[i]->imie , imie ) == 0 )
		{
			drukujJeden(i);
			ile++;
		}
	}
	szukajKoniec(ile);
}

// SZUKANIE NUMERU

void szukajNumeru() // szuka osoby o podanym numerze telefonu
{
	int numer;
	int i=0,ile=0;

	printf("\n Podaj numer: ");
	scanf("%i",&numer);
	getchar();

	for (i=0; i<ilosc; i++)
	{	
		if ( wykaz[i]->numer == numer )
		{
			drukujJeden(i);
			ile++;
		}
	}
	szukajKoniec(ile);
}


// USUWANIE



void usun(int jaki) // usuwa rekord z podanej cofa wszystkie nastepne wkazniki o jedna pozycje
{
	int i;
	free(wykaz[jaki]);
	ilosc --;
	if (ilosc == 0) return; //jezeli zostalo 0 pozycji, to nie ma co przesuwac 
	
	for (i=jaki; i<ilosc; i++)
	{
		wykaz[i] = wykaz[i+1];
	}	
}

void znajdzUsun() // szuka i kasuje podana osobe z listy
{
	char nazw[20];
	int i=0,j,gdzie=0,ile=0;

	//pobierz nazwisko
	printf("\n Podaj nazwisko: ");
	scanf("%s",&nazw);
	getchar();

	// poszukaj tej osoby w wykazie
	for( i=0; i<ilosc; i++)
	{
		if ( strcmp( wykaz[i]->nazwisko , nazw ) == 0 )
		{
			// wypisz kogo usuwamy, poki jeszcze mamy dane
			printf(" > Usunieto %s\n", wykaz[i]->nazwisko, wykaz[i]->imie);
			//ok, teraz juz mozna go usunac
			usun(i);
			ile++;
		}
	}
	szukajKoniec(ile);
}


// GLOWNY PROGRAM

int main()
{
	// wyswietla w petli menu, do momentu podania 'k' z klawiatury
	char z;
	do
	{
		printf("\n\n MENU:\n"); 
    	printf("\n c - Czytaj z pliku lista.txt");
    	printf("\n z - Zapisz do pliku lista.txt");
    	printf("\n d - Drukuj ksiazke");
    	printf("\n w - Wstaw nowy kontakt");
    	printf("\n n - Szukaj nazwiska");
    	printf("\n i - Szukaj imienia");
    	printf("\n t - Szukaj numeru");
    	printf("\n u - Usun kontakt");
    	printf("\n k - Koniec");
    	printf("\n wybor: ");
    	fflush(stdin);	// wyczysc klawiature
		z = getchar(); getchar(); 
		//wybierz z menu
		switch(z)
		{
			case 'c' : czytaj(); break;
			case 'z' : zapisz(); break;
			case 'd' : drukuj(); break;
			case 'w' : wstaw(); break;
			case 'n' : szukajNazwiska(); break;
			case 'i' : szukajImienia(); break;
			case 't' : szukajNumeru(); break;
			case 'u' : znajdzUsun(); break;
		}
	} while(z!='k');
	
	return 0;
}
