
/************************************************************************/
/* Tutorial 1: Al Sur de los Alpes                                      */
/* Autor: JuanD                                                         */
/* Fecha: 29 Abril 2002                                                 */
/* Documento de diseo de escenario: Tutorial1.doc                      */
/************************************************************************/ 
/* Objetivos del tutorial:                                              */
/* a) Mostrar tropas bsicas                                            */
/* b) Manejo bsico de la cmara                                        */
/* c) Seleccin de tropas, seleccin y creacin de grupos               */
/* d) Centrado en tropas y centrado en cada una de las tropas del grupo */
/* e) Movimiento bsico, correr, encaramiento y puntos de ruta          */
/* f) Ataque bsico                                                     */
/* g) Tipos de terreno y movilidad de las tropas por ellos              */
/* h) Separacin y fusin de tropas                                     */
/* i) Nociones de emboscada y visibilidad                               */
/************************************************************************/
/* Condiciones de victoria:                                             */
/* a) Aniquilar a todas las tropas galas                                */
/* b) Colocar al explorador en la zona de salida                        */
/* d) Que no muera el explorador                                        */
/************************************************************************/

Var
{

  handle skiptutorial, nextstep, accion, hCamaraEnd;    // handles del tutorial
  float fcontador             = 0;                      // leccin actual
  bool mostrarTrayectoria     = FALSE;                  // auxiliar para trayectorias
  string aux;                                           // para pasar string*
  
  // bojetivos
  handle hObjReunirse;
  handle hObjExploradorVivo;
  handle hObjLlegadaSalida;
  handle hObjMataMata;
  
  bool llegadaSalida          = FALSE;
  bool enemigoDestruido       = FALSE;
    
  handle hCivGala;
  handle hTacticaCaza;
  handle hEstrategia;
    
  bool WH_cheat = FALSE;
}


#include "Funscript.h"


//////////////////////////////////////////////////////////
// Main: presentacion
//////////////////////////////////////////////////////////

Trigger "Main" [Activo]
(
  TRUE
)
Do
{
  
  // tips de la misin
  IntroducirTip("LTEXT_TIP0_TEXTO", "LTEXT_TIP0_TITULO");
  IntroducirTip("LTEXT_TIP1_TEXTO", "LTEXT_TIP1_TITULO");
  IntroducirTip("LTEXT_TIP2_TEXTO", "LTEXT_TIP2_TITULO");
  IntroducirTip("LTEXT_TIP3_TEXTO", "LTEXT_TIP3_TITULO");
  IntroducirTip("LTEXT_TIP4_TEXTO", "LTEXT_TIP4_TITULO");
  IntroducirTip("LTEXT_TIP5_TEXTO", "LTEXT_TIP5_TITULO");
  IntroducirTip("LTEXT_TIP6_TEXTO", "LTEXT_TIP6_TITULO");
  IntroducirTip("LTEXT_TIP7_TEXTO", "LTEXT_TIP7_TITULO");
  IntroducirTip("LTEXT_TIP8_TEXTO", "LTEXT_TIP8_TITULO");
  IntroducirTip("LTEXT_TIP9_TEXTO", "LTEXT_TIP9_TITULO");
  IntroducirTip("LTEXT_TIP10_TEXTO", "LTEXT_TIP10_TITULO");
    
  ActivarTrigger("Presentacion");
  
}


Trigger "Presentacion" [Inactivo]
(
  TRUE
)
Var
{
  handle hPresentacion;
  handle hEscape;
}
Do
{
  
  hPresentacion = CrearHandle("Bool");
  hEscape = CrearHandle("Bool");
/*ActivarCinemascope(TRUE);
ActivarPresentacion(FALSE, "", "", NULL);
ActivarCinemascope(TRUE);*/
  // cazar escape
  PonerHandleInterrupcion(hEscape);

  
  ActivarTrigger("Main2");
  DestruirTrigger("Presentacion"); 

}


//////////////////////////////////////////////////////////
// Trigger main2: inicializacin del tutorial
//////////////////////////////////////////////////////////
Trigger "Main2" [Inactivo]
(
  TRUE
)
Var
{
}
Do
{

	
  // inicializamos los handles que necesitamos	
  skiptutorial = CrearHandle("Bool");
  nextstep = CrearHandle("Bool");
  accion = CrearHandle("Bool");
  hCamaraEnd = CrearHandle("Bool");
  

  //ActivarTrigger("TirarPaAlante");
  ActivarTrigger("InicioTutorial");
  ActivarTrigger("Skip");
  
  // apagamos la lluvia
 // ModificarLluvia(0.0, 0.0, 100.0, 99999.0);
  
  DestruirTrigger("Main2");
    
}
//////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////
// Inicializacin del tutorial
//////////////////////////////////////////////////////////
Trigger "InicioTutorial" [Inactivo]
(
  TRUE	
)
Var
{
  handle hTimer;
}
Do
{
  // inicializamos el panel de tutorial	
  fcontador = 0;
  //hTimer = CrearTimer(2000);			// para que aparezca a los 2 segundos
  //Wait(hTimer);

  // creamos
  CrearPanelTutorial(skiptutorial,nextstep);
  
  ///////////////////////////////////////////////////////////////////////////
  // LECCIONES:
  
  // Leccin 0: infantera ligera
  IntroducirPasoTutorial("WH_OFF_TXT", "WH_OFF_TYTUL");
                         
  // Leccin 1: piqueros
  IntroducirPasoTutorial("WH_ON_TXT", "WH_ON_TYTUL");                         
  
  // Leccin 2: arqueros
  IntroducirPasoTutorial("LTEXT_TUTORIAL1_LECCION_02_TXT", "LTEXT_TUTORIAL1_LECCION_02_OBJ");                         
  
  //////////////////////////////////////////////////////////////////////////
 AvanzarPasoTutorial(fcontador); 
ActivarTrigger("Next");
ActivarTrigger("Accion");

  // Eliminar este trigger
 // DisposeHandle(&hTimer);
  DestruirTrigger("InicioTutorial");

	
}
//////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////
// Pasar al siguiente paso del tutorial
//////////////////////////////////////////////////////////
Trigger "Next" [Inactivo]
(
  Wait(nextstep)			// cada vez que nextstep esta a TRUE
)
Var
{
  handle hCamaraEnd;
  handle hEscape;
  float x, y;
  
}
Do
{
  if(fcontador==0)
  {
	fcontador = fcontador + 1;              // siguiente leccin
  }
  else
  {
	fcontador = fcontador - 1; 
  }

  if(WH_cheat==FALSE)
  {
	IluminarZonaOnOff(100, 2, 100, 200, "zona7", TRUE);
	IluminarZonaOnOff(30, 0, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(150, 2, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(160, 2, 120, 200, "zona7", TRUE);
	IluminarZonaOnOff(30, 2, 120, 200, "zona7", TRUE);
	IluminarZonaOnOff(170, 2, 135, 200, "zona7", TRUE);
	IluminarZonaOnOff(150, 2, 70, 200, "zona7", TRUE);
	IluminarZonaOnOff(30, 2, 70, 200, "zona7", TRUE);
	IluminarZonaOnOff(30, 2, 135, 200, "zona7", TRUE);
	IluminarZonaOnOff(40, 2, 145, 200, "zona7", TRUE);
	IluminarZonaOnOff(60, 2, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(90, 2, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(120, 2, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(120, 2, 10, 200, "zona7", TRUE);
	IluminarZonaOnOff(115, 2, 24, 200, "zona7", TRUE);
	IluminarZonaOnOff(90, 2, 10, 200, "zona7", TRUE);
	IluminarZonaOnOff(175, 2, 116, 200, "zona7", TRUE);
	IluminarZonaOnOff(175, 2, 127, 200, "zona7", TRUE);
	IluminarZonaOnOff(60, 2, 30, 200, "zona7", TRUE);
	IluminarZonaOnOff(109, 2, 176, 200, "zona7", TRUE);
	IluminarZonaOnOff(119, 2, 174, 200, "zona7", TRUE);
	IluminarZonaOnOff(143, 2, 154, 200, "zona7", TRUE);
	IluminarZonaOnOff(75, 2, 165, 200, "zona7", TRUE);
	IluminarZonaOnOff(85, 2, 158, 200, "zona7", TRUE);
	IluminarZonaOnOff(110, 2, 110, 200, "zona7", TRUE);
	IluminarZonaOnOff(120, 2, 100, 200, "zona7", TRUE);
	IluminarZonaOnOff(95, 2, 135, 200, "zona7", TRUE);
	IluminarZonaOnOff(67, 2, 115, 200, "zona7", TRUE);
	IluminarZonaOnOff(80, 2, 79, 200, "zona7", TRUE);
	IluminarZonaOnOff(95, 2, 64, 200, "zona7", TRUE);
	IluminarZonaOnOff(35, 2, 115, 200, "zona7", TRUE); 
	WH_cheat=TRUE;
  }
  else
  {
	IluminarZonaOnOff(100, 2, 100, 200, "zona7", FALSE);
	IluminarZonaOnOff(30, 0, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(150, 2, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(160, 2, 120, 200, "zona7", FALSE);
	IluminarZonaOnOff(30, 2, 120, 200, "zona7", FALSE);
	IluminarZonaOnOff(170, 2, 135, 200, "zona7", FALSE);
	IluminarZonaOnOff(150, 2, 70, 200, "zona7", FALSE);
	IluminarZonaOnOff(30, 2, 70, 200, "zona7", FALSE);
	IluminarZonaOnOff(30, 2, 135, 200, "zona7", FALSE);
	IluminarZonaOnOff(40, 2, 145, 200, "zona7", FALSE);
	IluminarZonaOnOff(60, 2, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(90, 2, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(120, 2, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(120, 2, 10, 200, "zona7", FALSE);
	IluminarZonaOnOff(115, 2, 24, 200, "zona7", FALSE);
	IluminarZonaOnOff(90, 2, 10, 200, "zona7", FALSE);
	IluminarZonaOnOff(175, 2, 116, 200, "zona7", FALSE);
	IluminarZonaOnOff(175, 2, 127, 200, "zona7", FALSE);
	IluminarZonaOnOff(60, 2, 30, 200, "zona7", FALSE);
	IluminarZonaOnOff(109, 2, 176, 200, "zona7", FALSE);
	IluminarZonaOnOff(119, 2, 174, 200, "zona7", FALSE);
	IluminarZonaOnOff(143, 2, 154, 200, "zona7", FALSE);
	IluminarZonaOnOff(75, 2, 165, 200, "zona7", FALSE);
	IluminarZonaOnOff(85, 2, 158, 200, "zona7", FALSE);
	IluminarZonaOnOff(110, 2, 110, 200, "zona7", FALSE);
	IluminarZonaOnOff(120, 2, 100, 200, "zona7", FALSE);
	IluminarZonaOnOff(95, 2, 135, 200, "zona7", FALSE);
	IluminarZonaOnOff(67, 2, 115, 200, "zona7", FALSE);
	IluminarZonaOnOff(80, 2, 79, 200, "zona7", FALSE);
	IluminarZonaOnOff(95, 2, 64, 200, "zona7", FALSE);
	IluminarZonaOnOff(35, 2, 115, 200, "zona7", FALSE);
	WH_cheat=FALSE;
  }	
  AvanzarPasoTutorial(fcontador);         // actualizar el panel en consecuencia
  
  DesactivarHandleBool(nextstep);         // fuera nextstep de momento
  QuitarVigilanciaHandleBool(accion);     // para evitar problemas por salto de paso
    
  /*if ( fcontador == 1 )			// piqueros
  {
    aux = "PIQUERO";				
    VigilarInterfazSeleccion(NULL, &aux, accion);
    ActivarTrigger("Accion");
  }
  else
  if ( fcontador == 2 )			// arqueros
  {
    aux = "ARQUERO";
    VigilarInterfazSeleccion(NULL, &aux, accion);
    ActivarTrigger("Accion");
  }*/

}


//////////////////////////////////////////////////////////
// Capturar el resultado de vigilar una orden
//////////////////////////////////////////////////////////
Trigger "Accion" [Inactivo]
(
  Wait(accion)
)
Do
{
  DesactivarTrigger("Accion");		// desactivar el trigger mientras no vigilemos otra accion
  mostrarTrayectoria = TRUE;		// para sealar que el paso se ha realizado y no saltado	
  DesactivarHandleBool(accion);
  ActivarHandleBool(nextstep);		// avanzar el paso del tutorial
}


///////////////////////////////////
Trigger "Skip" [Inactivo]
(
  Wait(skiptutorial)
)
Do
{
}

  
//////////////////////////////////////////////////////////
// trigger de final
//////////////////////////////////////////////////////////
Trigger "End" [Activo]
(
  TRUE
)
Do
{
}
//////////////////////////////////////////////////////////