/*
	XenoN Core Fragment Shader - Blur [Pass 1]
*/

varying vec4 gl_Color;
uniform sampler2D tex;

uniform vec2 texsize;
uniform float size;
uniform float intensity;
uniform float scale;

vec4 BluredColorV(sampler2D texture,vec4 col,float size,float intensity)
{
	if(texsize.x<=0.0)return(col);
	vec4 color=texture2D(texture,gl_TexCoord[0].xy)*intensity;
	float pix=1.0/texsize.y;
	float temp;
	for(float i=1.0;i<=size;i+=1.0)
	{
		temp=1.0-1.0/size*i;
		color+=texture2D(texture,gl_TexCoord[0].xy+vec2(0.0,pix*i*scale))*intensity*temp;
		color+=texture2D(texture,gl_TexCoord[0].xy-vec2(0.0,pix*i*scale))*intensity*temp;
	}
	return(color*col);
}

void main()
{
	gl_FragColor=BluredColorV(tex,gl_Color,size,intensity);
}
