#pragma once
#include <windows.h>
#include <CommCtrl.h>
#include <string>

class CWindowInput { 
  public:
    CWindowInput( HWND aParent = NULL );
    ~CWindowInput() {
      DestroyWindow( m_hwndMain );
      DeleteObject( m_fontDefault );
    }

    void SetParent( HWND aParent ) {
      m_hwndParent = aParent;
    }

    void MoveToCenter();

    void SetMessage( const char* aText ) const {
      SetWindowText( m_hwndStatic, aText );
    }

    void SetText( const char* aText ) const {
      SetWindowText( m_hwndEdit, aText );
    }

    void Run();

    void SetResult();
    const char* GetResult() const {
      return m_text.c_str();
    }

  private:
    HWND m_hwndParent,
         m_hwndMain,
         m_hwndEdit,
         m_hwndStatic,
         m_hwndButton;

    static int const m_idButton, 
                     m_idStatic,
                     m_idEdit;

    HFONT m_fontDefault;
    HBRUSH m_brushBackground;
    std::string m_text;

    static const char* const m_className;

    void RegisterWindowClass();
    void CreateForm();
    static LRESULT CALLBACK WindowProc( HWND aHandle, UINT aMessage, WPARAM aParamW, LPARAM aParamL );
};
