#include "WindowInput.h"
#define WM_BREAK WM_USER

const char* const CWindowInput::m_className  = "CLASS_WNDINPUT";
int const         CWindowInput::m_idButton = 100;
int const         CWindowInput::m_idStatic = 101;
int const         CWindowInput::m_idEdit   = 102;

CWindowInput::CWindowInput( HWND aParent ) {
  m_hwndParent = aParent;
  m_hwndMain = m_hwndEdit = m_hwndStatic = m_hwndButton = NULL;
  m_brushBackground = GetSysColorBrush( COLOR_BTNFACE );

  RegisterWindowClass();
  CreateForm();
}

void CWindowInput::RegisterWindowClass() {
  WNDCLASSEX wndClass = {0};
  wndClass.cbSize = sizeof( WNDCLASSEX );
  wndClass.hInstance = GetModuleHandle( NULL );
  wndClass.hbrBackground = m_brushBackground;
  wndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
  wndClass.lpszClassName = m_className;
  wndClass.lpfnWndProc = WindowProc;
  
  RegisterClassEx( &wndClass );
}

void CWindowInput::Run() {
  MSG msg = {0};

  MoveToCenter();
  ShowWindow( m_hwndMain, SW_SHOW );
  EnableWindow( m_hwndParent, false );
  EnableWindow( m_hwndMain, true );
  SetForegroundWindow( m_hwndMain );

  while ( true ) {
    if ( GetMessage( &msg, 0, 0, 0 ) > 0 ) {
      if ( msg.message == WM_BREAK )
        break;

      TranslateMessage( &msg );
      DispatchMessage( &msg );
    }
  }

  ShowWindow( m_hwndMain, SW_HIDE );
  EnableWindow( m_hwndParent, true );
  EnableWindow( m_hwndMain, false );
  ShowWindow( m_hwndParent, SW_SHOW );
  SetForegroundWindow( m_hwndParent );
  SetFocus( m_hwndParent );
  SetActiveWindow( m_hwndParent );

  SetResult();
}

void CWindowInput::SetResult() {
  int length = GetWindowTextLength( m_hwndEdit ) + 1;
  char* buffer = new char[length];
  GetWindowText( m_hwndEdit, buffer, length );
  m_text = buffer;

  delete [] buffer;
}

void CWindowInput::CreateForm() {
  NONCLIENTMETRICS ncMetrics = {0};
  ncMetrics.cbSize = sizeof( NONCLIENTMETRICS ) - 4;
  SystemParametersInfo( SPI_GETNONCLIENTMETRICS, 0, &ncMetrics, 0 );
  m_fontDefault = CreateFontIndirect( &ncMetrics.lfMessageFont );

  m_hwndMain = CreateWindowEx( WS_EX_TOOLWINDOW, m_className, "Get string", WS_POPUP | WS_CAPTION,
                               0, 0, 400, 110,
                               0, NULL, GetModuleHandle( NULL ), this );

  RECT rect;
  GetClientRect( m_hwndMain, &rect );

  m_hwndEdit = CreateWindowEx( 0, WC_EDIT, "", ES_AUTOHSCROLL | ES_AUTOVSCROLL | WS_VISIBLE | WS_CHILD | WS_BORDER,
                               10, 30, rect.right - rect.left - 20, rect.bottom - rect.top - 65,
                               m_hwndMain, (HMENU) m_idEdit, GetModuleHandle( NULL ), NULL );

  m_hwndStatic = CreateWindowEx( 0, WC_STATIC, "", WS_VISIBLE | WS_CHILD, 
                                 10, 10, rect.right - rect.left - 20, 18,
                                 m_hwndMain, (HMENU) m_idStatic, GetModuleHandle( NULL ), NULL );

  m_hwndButton = CreateWindowEx( 0, WC_BUTTON, "OK", WS_VISIBLE | WS_CHILD,
                                 150, rect.bottom - rect.top - 30, 100, 25,
                                 m_hwndMain, (HMENU) m_idButton, GetModuleHandle( NULL ), NULL );
}

void CWindowInput::MoveToCenter() {
  RECT rect;
  GetWindowRect( m_hwndMain, &rect );

  SetWindowPos( m_hwndMain, 0, 
                GetSystemMetrics( SM_CXSCREEN ) / 2 - (rect.right - rect.left) / 2, 
                GetSystemMetrics( SM_CYSCREEN ) / 2 - (rect.bottom - rect.top) / 2,
                0, 0, SWP_NOZORDER | SWP_NOSIZE );
}

LRESULT CALLBACK CWindowInput::WindowProc( HWND aHandle, UINT aMessage, WPARAM aParamW, LPARAM aParamL ) {
  CWindowInput* self = (CWindowInput*) GetWindowLong( aHandle, GWL_USERDATA );

  switch ( aMessage ) {
    case WM_CREATE:
      self = (CWindowInput*) ((LPCREATESTRUCT) aParamL)->lpCreateParams;
      SetWindowLong( aHandle, GWL_USERDATA, (LONG) self );
      break;

    case WM_CLOSE:
      PostMessage( aHandle, WM_BREAK, 0, 0 );
      break;

    case WM_PARENTNOTIFY:
      if ( LOWORD( aParamW ) == WM_CREATE )
        SendDlgItemMessage( aHandle, HIWORD( aParamW ), WM_SETFONT, (WPARAM) self->m_fontDefault, TRUE );
      break;

    case WM_COMMAND:
      if ( aParamW == self->m_idButton )
        PostMessage( aHandle, WM_CLOSE, 0, 0 );
      break;

    default:
      return DefWindowProc( aHandle, aMessage, aParamW, aParamL );
  }

  return 0;
}
