// used per vertex attributes.
attribute vec3 in_Position;
attribute vec2 in_TextureCoord;

// used per program uniforms.
uniform vec2 uScale;
uniform vec4 uBaseUV;
uniform vec4 uMaskUV;

// used temporary variables to send data to fragment program.
varying vec2 coord;
varying vec2 coordMask;
varying vec2 offset0;
varying vec2 offset1;
varying vec2 offset2;
varying vec2 offset3;

void main()
{
    // send base texture coord to fragment program.
    coord = in_TextureCoord;
    // convert base sub-texture coord into unit coord space.
    vec2 unitCoord = ( coord - uBaseUV.xy ) / ( uBaseUV.zw - uBaseUV.xy );
    // calculate mask sub-texture coord using unit coord and send it to fragment program.
    coordMask = mix( uMaskUV.xy, uMaskUV.zw, unitCoord );
    // calculate blur offsets and send them to fragment program.
    offset0 = uScale * vec2( 1.0 );
    offset1 = uScale * vec2( 2.0 );
    offset2 = uScale * vec2( 3.0 );
    offset3 = uScale * vec2( 4.0 );
    // convert vertex position from it's local space to world-view-projection space and send result to fragment program.
    gl_Position = gm_Matrices[ MATRIX_WORLD_VIEW_PROJECTION ] * vec4( in_Position, 1.0 );
}

//######################_==_YOYO_SHADER_MARKER_==_######################@~// used per program uniforms.
uniform sampler2D sMask;

// used temporary variables to receive data from vertex program.
varying vec2 coord;
varying vec2 coordMask;
varying vec2 offset0;
varying vec2 offset1;
varying vec2 offset2;
varying vec2 offset3;

void main()
{
    // sample texels from base and mask textures.
    vec4 colBase = texture2D( gm_BaseTexture, coord );
    vec4 colMask = texture2D( sMask, coordMask );
    
    // store base pixel and multiply it by it's blur weight.
    vec4 col = colBase * vec4( 0.227027027 );
    
    // accumulate blurred pixels in positive blur direction.
    col += texture2D( gm_BaseTexture, coord + offset0 ) * vec4( 0.1945945946 );
    col += texture2D( gm_BaseTexture, coord + offset1 ) * vec4( 0.1216216216 );
    col += texture2D( gm_BaseTexture, coord + offset2 ) * vec4( 0.0540540541 );
    col += texture2D( gm_BaseTexture, coord + offset3 ) * vec4( 0.0162162162 );
    
    // accumulate blurred pixels in negative blur direction.
    col += texture2D( gm_BaseTexture, coord - offset0 ) * vec4( 0.1945945946 );
    col += texture2D( gm_BaseTexture, coord - offset1 ) * vec4( 0.1216216216 );
    col += texture2D( gm_BaseTexture, coord - offset2 ) * vec4( 0.0540540541 );
    col += texture2D( gm_BaseTexture, coord - offset3 ) * vec4( 0.0162162162 );
    
    // mix blurred color with base color by mask pixel alpha as mixing factor.
    gl_FragColor = mix( col, colBase, vec4( colMask.w ) );
}

