// If you want to experiment, here's how to compile using gcc:
//  linux: gcc hallusinaattori.c -o hallusinaattori -lSDL -lm -s
//  windows: gcc hallusinaattori.c -o hallusinaattori.exe -lmingw32 -lSDLmain -lSDL -lm -s

// Bloat & bubblegum & hack & stuff, I know :(

#include <stdio.h>
#include <SDL/SDL.h>
#include <string.h>
#include <math.h>

// For cleanliness (huh?)
typedef struct {
	float r, g, b;
} fadehax;
fadehax conv(int r, int g, int b) {
	fadehax c;
	c.r = r / 255.;
	c.g = g / 255.;
	c.b = b / 255.;
	return c;
}
int main(int argc, char **argv) {
	SDL_Surface *scr;
	SDL_Event ev;
	int run, x, y, butn, clrmode, dir;
	Uint32 clr, clrdata[256], time, dtime, ftime, *p1, *p2, *p3, *p4;
	fadehax fade[2048], fclr;
	float ball, bar, dist, *hypots, *hyp;

	if (SDL_Init(SDL_INIT_VIDEO) < 0) {
		fprintf(stderr, "SDL_Init eror :( %s\n", SDL_GetError());
		return 1;
	}
	scr = SDL_SetVideoMode(640, 480, 32, SDL_SWSURFACE | SDL_DOUBLEBUF | SDL_RESIZABLE);
	if (!scr) {
		fprintf(stderr, "SDL_SetVideoMode eror :( %s\n", SDL_GetError());
		SDL_Quit();
		return 2;
	}
	SDL_WM_SetCaption("hallusinaattori", NULL);
	
	for (x = 0; x < 256; x++) {
		// Precalc, sin is slow
		clr = (Uint32)((sin(x / 256. * M_PI) * sin(x / 256. * M_PI)) * 255);
		clrdata[x] = (clr << 16) | (clr << 8) | clr;
		// Uber bloat shadehack
		fade[          x] = conv(0, 0, x); // b
		fade[    256 + x] = conv(0, x, 255); // gb
		fade[2 * 256 + x] = conv(0, 255, 255 - x); // g
		fade[3 * 256 + x] = conv(x, 255, 0); // rg
		fade[4 * 256 + x] = conv(255, 255 - x, 0); // r
		fade[5 * 256 + x] = conv(255, 0, x); // rb
		fade[6 * 256 + x] = conv(255, x, 255); // rgb
		fade[7 * 256 + x] = conv(255 - x, 255 - x, 255 - x); // 0

	}
	// ho ho, precalc pixel distances from the center, hypot is slow!11
	hypots = (float *)malloc(scr->w / 2 * scr->h / 2 * sizeof(float));
	if (hypots == NULL) {
		fprintf(stderr, "malloc eror :(\n");
		SDL_Quit();
		return 3;
	}
	hyp = hypots;
	for (y = scr->h / 2 - 1; y >= 0; y--)
		for (x = scr->w / 2 - 1; x >= 0; x--)
			*hyp++ = hypot(x, y);
	run = 1;
	bar = 13; // size factor
	dtime = 0; // delta, frame time
	time = 0; // speed thingie
	clrmode = 7;
	dir = 0; // scroll direction
	while (run) {
		ftime = SDL_GetTicks();
		while (SDL_PollEvent(&ev)) {
			if (ev.type == SDL_QUIT) run = 0;
			else if (ev.type == SDL_KEYDOWN) {
				if (ev.key.keysym.sym == SDLK_ESCAPE) run = 0;
				else if (ev.key.keysym.sym == SDLK_SPACE) {
					clrmode = (clrmode + 1) & 7;
					if (clrmode > 0) {
						for (x = 0; x < 256; x++) {
							clr = (int)((sin(x / 256. * M_PI) * sin(x / 256. * M_PI)) * 255);
							// bit hacks <3
							clrdata[x] = (clrmode & 4 ? (clr << 16) : 0) | (clrmode & 2 ? (clr << 8) : 0) | (clrmode & 1 ? clr : 0);
						}
					} else { // mask to interval 0..255, special shade has its own colors
						for (x = 0; x < 256; x++) clrdata[x] &= 255;
					}
				} else if (ev.key.keysym.sym == SDLK_RETURN) dir = 1 - dir;
			} else if (ev.type == SDL_VIDEORESIZE) {
				// make sure width and height aren't odd so we won't have ugly black lines in the center because of the optimization hacks
				scr = SDL_SetVideoMode(ev.resize.w & ~1, ev.resize.h & ~1, 32, SDL_SWSURFACE | SDL_DOUBLEBUF | SDL_RESIZABLE);
				if (scr == NULL) {
					fprintf(stderr, "SDL_SetVideoMode eror :( %s\n", SDL_GetError());
					free(hypots);
					SDL_Quit();
					return 4;
				}
				// size changed! we need a new distance array
				hypots = (float *)realloc(hypots, scr->w / 2 * scr->h / 2 * sizeof(float));
				if (hypots == NULL) {
					fprintf(stderr, "malloc eror :(\n");
					SDL_Quit();
					return 5;
				}
				hyp = hypots;
				for (y = scr->h / 2 - 1; y >= 0; y--)
					for (x = scr->w / 2 - 1; x >= 0; x--)
						*hyp++ = hypot(x, y);
			}
		}
		
		butn = SDL_GetMouseState(&x, &y);
		if (butn & SDL_BUTTON(1)) bar += 0.2;
		// button 2 is wheel in case of wheely mouses so test 3 too
		else if (((butn & SDL_BUTTON(3)) || (butn & SDL_BUTTON(2))) && bar > 0.2) bar -= 0.2;
		
		// windows messes these up sometimes when the cursor isn't inside our window
		if (x < 0) x = 0; else if (x >= scr->w) x = scr->w - 1;
		if (y < 0) y = 0; else if (y >= scr->h) y = scr->h - 1;

		if (dir == 0) time += (Uint32)(3. * x / scr->w * dtime);
		else time -= (Uint32)(3. * x / scr->w * dtime);
		// circle equation x^2+y^2=r^2
		ball = (float)y / scr->h / 4.;
		ball = hypot(ball * scr->w, ball * scr->h);

		if (SDL_MUSTLOCK(scr)) SDL_LockSurface(scr);
		// pointer hacks == speed \o/ (http://andwiki.dy.fi/Gentoosyndrooma, for Finns)
		// even SDL sucks, this runs quite fast in fullscreen :-o
		// oh look, the screen is funnily symmetric
		p1 = (Uint32 *)scr->pixels; // top left
		p2 = p1 + scr->w - 1; // top right
		p3 = (Uint32 *)scr->pixels + scr->w * (scr->h - 1); // bottom left
		p4 = p3 + scr->w - 1; // bottom right
		hyp = hypots;
		// calculate only 1/4th => speed!
		for (y = 0; y < scr->h >> 1; y++) {
			for (x = 0; x < scr->w >> 1; x++) {
				dist = *hyp++;
				// inside the ball? (eh, circle :/) roll in another direction
				if (dist <= ball) clr = clrdata[((int)(bar * dist) + time) & 255];
				else clr = clrdata[((int)(bar * dist) - time) & 255];
				
				if (clrmode == 0) { // super mega cool (not) automagic shade
					fclr = fade[(time >> 3) & 2047];
					clr = ((Uint8)(fclr.r * clr) << 16) | ((Uint8)(fclr.g * clr) << 8) | (Uint8)(fclr.b * clr);
				}
				*p1++ = clr;
				*p2-- = clr;
				*p3++ = clr;
				*p4-- = clr;
			}
			// next row
			p1 += scr->w >> 1;
			p2 += scr->w + (scr->w >> 1);
			p3 -= scr->w + (scr->w >> 1);
			p4 -= scr->w >> 1;
		}
		if (SDL_MUSTLOCK(scr)) SDL_UnlockSurface(scr);
		SDL_Flip(scr);
		dtime = SDL_GetTicks() - ftime;
		// prevent from sucking too much cpu usage
		if (dtime < 15) SDL_Delay(15 - dtime);
		dtime = SDL_GetTicks() - ftime;
	}
	free(hypots);
	SDL_Quit();
	return 0;
}
