#define xrp_ini
//Initiate the functions for the xrp
global.ADD = external_define(xrp,"_add",1,0,1,1);
global.COMPACT = external_define(xrp,"_compact",1,0,1,1);
global.COUNT = external_define(xrp,"_count",1,0,0);
global.DECRYPT = external_define(xrp,"_decrypt",1,0,1,0);
global.ENCRYPT = external_define(xrp,"_encrypt",1,0,1,0);
global.EXTRACT = external_define(xrp,"_extract",1,0,2,1,0);
global.FETCH = external_define(xrp,"_fetch",1,1,2,1,0);
global.INSERT = external_define(xrp,"_insert",1,0,2,1,0);
global.NAME = external_define(xrp,"_name",1,1,1,0);
global.NUMB = external_define(xrp,"_numb",1,0,1,1);
global.REMOVE = external_define(xrp,"_remove",1,1,1,0);
global.SET = external_define(xrp,"_set",1,0,1,1);
global.SIZE = external_define(xrp,"_size",1,0,1,0);
//Set the xrp filetype icon.  fileAssociate script by Daniel Barras
xrp_associate('.xrp', 'XRP External Resource File', 'xrpicon.ico', '', '');
#define xrp_add
//argument0: target file to be added to xrp file
return external_call(global.ADD,argument0);
#define xrp_associate
  /*
  fileAssociate script by Daniel Barras
  Usage: fileAssociate(argument0, argument1, argument2, argument3, argument4);
  argument0 = File extension ie: '.txt'
  argument1 = File description
  argument2 = Icon file
  argument3 = Application to open file
  argument4 = Application arguments
  */
  registry_set_root(2);
  registry_write_string_ext(argument0, '', argument1);
  registry_write_string_ext(argument1, '', argument1);
  registry_write_string_ext(argument1 + '\DefaultIcon\', '', argument2 + ', 0');
  registry_write_string_ext(argument1 + '\shell\open\command\', '', argument3 + ' "%1"' + ' "' + argument4 + '"');
#define xrp_compact
//argument0: folder
return external_call(global.COMPACT,argument0);
#define xrp_compress
//run pacl, which compresses the XRP
//return 0: success
//return 1 or 2: error
//argument0: name of .zip (no extension)
//argument1: name of XRP
return execute_program("PACOMP.EXE",'-q -u "'+argument0+'.zip" "'+argument1+'"',1);
#define xrp_count
//counts the number of files in the XRP
return external_call(global.COUNT);
#define xrp_decompress
//run pacl, which decompresses the XRP
//return 0: success
//return -1 or -2: error
//argument0: name of .xrp
return execute_program("PAEXT.EXE","-q -o+ "+argument0+".zip",1);
#define xrp_decrypt
//Decrypts the file.
//You may use this function to encrypt instead,
//and use _encrypt to decrypt.
////argument0: seed to decrypt (when encrypting you must have the same seed!!)
return external_call(global.DECRYPT,argument0);
#define xrp_encrypt
//Encrypts the file.
//You may call this function multiple times,
//and call _decrypt the same amount of times to decrypt.
//argument0: seed to encrypt (when decrypting you must have the same seed!!)
return external_call(global.ENCRYPT,argument0);
#define xrp_extract
/* * * *
argument0: folder to extract to
argument1: extension
Extracts all the items in the mpq file to the folder.
Uses the item index as the filename.
Appends the extensions to the files if ext is non-zero.
Extracted files will overwrite previously existing files.
If a file is not overwritten, it will remain.
Creates the folder if it does not exist.
>Returns the number of files extracted.
>Error if XRP does not exist or is corrupted.
* * * */
return external_call(global.EXTRACT,argument0,argument1);
#define xrp_fetch
/* * * *
argument0: target
argument1: index
Extracts the n'th item from the xrp file into the target file.
The extension of the file is automatically appended and returned.
If target exists, it is overwritten.
>Error if XRP does not exist or is corrupted.
>Error if n is greater than the number of items.
* * * */
return external_call(global.FETCH,argument0,argument1);
#define xrp_insert
/* * * *
argument0: target
argument1: index of file to be inserted in front of
Uses the filename as the name.
Creates the XRP if it does not exist.
Increases the number of items by 1.
>Returns the size of the written item.
>Returns -1 if target does not exist.
>Error if XRP is corrupted.
* * * */
return external_call(global.FETCH,argument0,argument1);
#define xrp_name
//argument0: index of file
//Returns the name of the n'th item in the XRP file.
return external_call(global.NAME,argument0);
#define xrp_numb
//argument0: name of file
//Returns the index of the first item with the given name
//>Returns -1 if no items have given name.
return external_call(global.NAME,argument0);
#define xrp_remove
//Rargument0: Index of file to remove
//Decreases the number of items by 1.
//>Returns the name of the removed item.
return external_call(global.NAME,argument0);
#define xrp_set
//set it so that you dont have to call name.xrp every time
//argument0: xrp data file
return external_call(global.SET,argument0);
#define xrp_size
//argument0: index
return external_call(global.SIZE,argument0);
