package zboj.ZbojeckiBrowarWEB.beans;

import java.io.Serializable;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;


@Named
@SessionScoped
public class Browar implements Serializable {
	private static final long serialVersionUID = 1L;

	@Inject
	BrowarList browarList;
	
	@NotNull
	@NotEmpty
	@Digits(fraction = 1, integer = 2)
	private double procenty = 3.4;
	
	@NotNull
	@NotEmpty
	private String nazwa = "Mocny Full";
	
	public Browar() {
		
	}
	
	public Browar(String nazwa, double procenty) {
		this.nazwa = nazwa;
		this.procenty = procenty;
	}
	
	public Browar(Browar dane) {
		this.nazwa = dane.nazwa;
		this.procenty = dane.procenty;
	}
	
	public String getNazwa() {
		return this.nazwa;
	}
	
	public void setNazwa(String nazwa) {
		this.nazwa = nazwa;
	}
	
	public double getProcenty() {
		return this.procenty;
	}
	
	public void setProcenty(double p) {
		this.procenty = p;
	}
	
	//nawigacja
	public String redirect(){
		return "wybrane";
	}
	
	public String addBrowar() {
		browarList.dodajBrowar(new Browar (this));
		return "home";
	}
}
