data:extend({
  {
    type = "technology",
    name = "kr-antimatter-ammo",
    icon = "__Krastorio2Assets__/technologies/antimatter-ammo.png",
    icon_size = 256,
    unit = {
      time = 60,
      count = 2500,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-antimatter-reactor", "kr-laser-artillery-turret", "kr-rocket-turret" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-antimatter-turret-rocket" },
      { type = "unlock-recipe", recipe = "kr-antimatter-artillery-shell" },
      { type = "unlock-recipe", recipe = "kr-antimatter-rocket" },
      { type = "unlock-recipe", recipe = "kr-antimatter-railgun-shell" },
    },
  },
  {
    type = "technology",
    name = "kr-antimatter-reactor",
    icon = "__Krastorio2Assets__/technologies/antimatter-reactor.png",
    icon_size = 256,
    prerequisites = { "kr-fusion-energy", "kr-singularity-tech-card" },
    unit = {
      time = 60,
      count = 2000,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    order = "g-f-z",
    effects = {
      { type = "unlock-recipe", recipe = "kr-antimatter-reactor" },
      { type = "unlock-recipe", recipe = "kr-empty-antimatter-fuel-cell" },
      { type = "unlock-recipe", recipe = "kr-charged-antimatter-fuel-cell" },
    },
  },
  {
    type = "technology",
    name = "kr-antimatter-reactor-equipment",
    icons = util.technology_icon_constant_equipment(
      "__Krastorio2Assets__/technologies/antimatter-reactor-equipment.png"
    ),
    upgrade = false,
    unit = {
      time = 45,
      count = 500,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-fusion-reactor-equipment", "kr-antimatter-reactor" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-antimatter-reactor-equipment" },
    },
  },
  {
    type = "technology",
    name = "kr-intergalactic-transceiver",
    icon = "__Krastorio2Assets__/technologies/intergalactic-transceiver.png",
    icon_size = 256,
    unit = {
      time = 60,
      count = 3000,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-singularity-tech-card" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-intergalactic-transceiver" },
    },
  },
  {
    type = "technology",
    name = "kr-logo",
    enabled = false,
    icon = "__Krastorio2Assets__/technologies/k-logo.png",
    icon_size = 256,
    unit = {
      time = 60,
      count = 666000,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-intergalactic-transceiver" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-logo" },
    },
  },
  {
    type = "technology",
    name = "kr-matter-cube",
    icon = "__Krastorio2Assets__/technologies/matter-cube.png",
    icon_size = 256,
    order = "g-f-z",
    unit = {
      time = 60,
      count = 500,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-singularity-tech-card" },
    effects = {}, -- Populated by matter util
  },
  {
    type = "technology",
    name = "kr-personal-laser-defense-mk4-equipment",
    icons = util.technology_icon_constant_equipment(
      "__Krastorio2Assets__/technologies/personal-laser-defense-mk4-equipments.png"
    ),
    icon_size = 256,
    order = "g-m",
    unit = {
      time = 90,
      count = 500,
      ingredients = {
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = {
      "kr-personal-laser-defense-mk3-equipment",
      "kr-singularity-tech-card",
    },
    effects = {
      { type = "unlock-recipe", recipe = "kr-personal-laser-defense-mk4-equipment" },
    },
  },
  {
    type = "technology",
    name = "kr-planetary-teleporter",
    icon = "__Krastorio2Assets__/technologies/planetary-teleporter.png",
    icon_size = 256,
    unit = {
      time = 60,
      count = 500,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "effect-transmission", "kr-singularity-tech-card" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-planetary-teleporter" },
      { type = "unlock-recipe", recipe = "kr-gps-satellite" },
    },
  },
  {
    type = "technology",
    name = "kr-power-armor-mk4",
    icon = "__Krastorio2Assets__/technologies/power-armor-mk4.png",
    icon_size = 256,
    upgrade = false,
    unit = {
      time = 90,
      count = 750,
      ingredients = {
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "kr-power-armor-mk3", "kr-singularity-tech-card" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-power-armor-mk4" },
    },
  },
  {
    type = "technology",
    name = "kr-singularity-beacon",
    icon = "__Krastorio2Assets__/technologies/singularity-beacon.png",
    icon_size = 256,
    unit = {
      time = 60,
      count = 1000,
      ingredients = {
        { "production-science-pack", 1 },
        { "utility-science-pack", 1 },
        { kr_optimization_tech_card_name, 1 },
        { "kr-matter-tech-card", 1 },
        { "kr-advanced-tech-card", 1 },
        { "kr-singularity-tech-card", 1 },
      },
    },
    prerequisites = { "effect-transmission", "kr-singularity-tech-card" },
    effects = {
      { type = "unlock-recipe", recipe = "kr-singularity-beacon" },
    },
  },
})
