local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-singularity-beacon",
    energy_required = 10,
    enabled = false,
    ingredients = {
      { type = "item", name = "beacon", amount = 1 },
      { type = "item", name = "kr-ai-core", amount = 10 },
      { type = "item", name = "processing-unit", amount = 20 },
      { type = "item", name = "kr-energy-control-unit", amount = 10 },
    },
    results = { { type = "item", name = "kr-singularity-beacon", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-singularity-beacon",
    icon = "__Krastorio2Assets__/icons/entities/singularity-beacon.png",
    subgroup = "module",
    order = "8[singularity-beacon]",
    place_result = "kr-singularity-beacon",
    stack_size = 50,
  },
  {
    type = "beacon",
    name = "kr-singularity-beacon",
    icon = "__Krastorio2Assets__/icons/entities/singularity-beacon.png",
    flags = { "placeable-player", "player-creation" },
    minable = { mining_time = 0.5, result = "kr-singularity-beacon" },
    collision_box = { { -0.75, -0.75 }, { 0.75, 0.75 } },
    selection_box = { { -0.9, -0.9 }, { 0.9, 0.9 } },
    module_slots = 2,
    allowed_effects = { "consumption", "speed", "pollution" },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
    },
    energy_usage = "750kW",
    supply_area_distance = 2.0,
    distribution_effectivity = 2.25,
    profile = require("prototypes.buildings.singularity-beacon-profile"),
    beacon_counter = "same_type",
    max_health = 300,
    corpse = "medium-remnants",
    dying_explosion = "kr-matter-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    base_picture = {
      filename = "__Krastorio2Assets__/buildings/singularity-beacon/singularity-beacon.png",
      width = 360,
      height = 360,
      shift = util.by_pixel(0, -5),
      scale = 0.25,
    },
    open_sound = { filename = "__Krastorio2Assets__/sounds/buildings/open.ogg", volume = 1 },
    close_sound = { filename = "__Krastorio2Assets__/sounds/buildings/close.ogg", volume = 1 },
    vehicle_impact_sound = sounds.generic_impact,
    water_reflection = {
      pictures = {
        filename = "__Krastorio2Assets__/buildings/singularity-beacon/singularity-beacon-reflection.png",
        priority = "extra-high",
        width = 20,
        height = 25,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5,
      },
      rotate = false,
      orientation_to_variation = false,
    },
    animation = {
      layers = {
        {
          filename = "__Krastorio2Assets__/buildings/singularity-beacon/singularity-beacon-w-light.png",
          width = 190,
          height = 214,
          frame_count = 10,
          line_length = 5,
          shift = util.by_pixel(0, -11.5),
          draw_as_light = true,
          flags = { "light" },
          scale = 0.25,
          animation_speed = 0.5,
        },
        {
          filename = "__Krastorio2Assets__/buildings/singularity-beacon/singularity-beacon-w.png",
          width = 190,
          height = 214,
          frame_count = 10,
          line_length = 5,
          shift = util.by_pixel(0, -11.5),
          scale = 0.25,
          animation_speed = 0.5,
        },
      },
    },
    radius_visualisation_picture = {
      filename = "__base__/graphics/entity/beacon/beacon-radius-visualization.png",
      priority = "extra-high-no-scale",
      width = 10,
      height = 10,
    },
  },
})
