local shelter_animation = {
  layers = {
    {
      filename = "__Krastorio2Assets__/buildings/shelter/shelter-light.png",
      priority = "high",
      width = 512,
      height = 512,
      scale = 0.45,
      shift = { -0.05, 0 },
      draw_as_light = true,
      repeat_count = 6,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter/shelter.png",
      priority = "high",
      width = 512,
      height = 512,
      scale = 0.45,
      shift = { -0.05, 0 },
      repeat_count = 6,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter/shelter-anim.png",
      priority = "high",
      width = 512,
      height = 512,
      scale = 0.45,
      shift = { -0.05, 0 },
      frame_count = 6,
      line_length = 3,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter/shelter-shadow.png",
      priority = "high",
      width = 512,
      height = 512,
      scale = 0.45,
      shift = { 0.42, 0 },
      repeat_count = 6,
      animation_speed = 0.5,
      draw_as_shadow = true,
    },
  },
}

data:extend({
  {
    type = "recipe",
    name = "kr-shelter",
    energy_required = 10,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-iron-beam", amount = 25 },
      { type = "item", name = "iron-plate", amount = 25 },
      { type = "item", name = "copper-cable", amount = 10 },
      { type = "item", name = "coal", amount = 50 },
    },
    results = { { type = "item", name = "kr-shelter", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-shelter",
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    subgroup = "storage",
    order = "aaa",
    place_result = "kr-shelter-container",
    stack_size = 1,
  },
  {
    type = "electric-energy-interface",
    name = "kr-shelter",
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    flags = { "not-on-map" },
    hidden = true,
    fast_replaceable_group = "kr-shelter",
    allow_copy_paste = false,
    minable = { mining_time = 0.5, result = "kr-shelter" },
    energy_source = {
      type = "electric",
      buffer_capacity = "120kJ",
      usage_priority = "primary-output",
      input_flow_limit = "0kW",
      output_flow_limit = "120kW",
      render_no_power_icon = false,
      render_no_network_icon = false,
    },
    energy_production = "120kW",
    animation = shelter_animation,
    continuous_animation = true,
  },
  {
    type = "container",
    name = "kr-shelter-container",
    localised_name = { "entity-name.kr-shelter" },
    localised_description = { "entity-description.kr-shelter" },
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    flags = { "not-blueprintable", "player-creation" },
    collision_box = { { -2.75, -2.75 }, { 2.75, 2.75 } },
    selection_box = { { -3, -3 }, { 3, 3.20 } },
    allow_copy_paste = false,
    minable = { mining_time = 0.5, result = "kr-shelter" },
    inventory_size = 200,
    max_health = 1500,
    corpse = "kr-medium-random-pipes-remnant",
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    open_sound = { filename = "__Krastorio2Assets__/sounds/buildings/open.ogg", volume = 1 },
    close_sound = { filename = "__Krastorio2Assets__/sounds/buildings/close.ogg", volume = 1 },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture = shelter_animation,
    water_reflection = {
      pictures = {
        filename = "__Krastorio2Assets__/buildings/shelter/shelter-reflection.png",
        priority = "extra-high",
        width = 60,
        height = 50,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5,
      },
      rotate = false,
      orientation_to_variation = false,
    },
    icon_draw_specification = { scale = 1.5, scale_for_many = 1.5 },
  },
  {
    type = "lamp",
    name = "kr-shelter-light",
    localised_name = { "entity-name.kr-shelter" },
    localised_description = { "entity-description.kr-shelter" },
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    flags = { "not-on-map" },
    hidden = true,
    allow_copy_paste = false,
    energy_source = { type = "void" },
    energy_usage_per_tick = "1W",
    darkness_for_all_lamps_on = 0.2,
    darkness_for_all_lamps_off = 0.1,
    light = {
      intensity = 0.8,
      size = 12,
      shift = { 0.0, 1.75 },
      color = { r = 0.95, g = 0.88, b = 0.85 },
    },
    light_when_colored = {
      intensity = 1,
      size = 6,
      color = { r = 1.0, g = 1.0, b = 1.0 },
    },
    glow_size = 6,
    glow_color_intensity = 0.25,
    picture_off = util.empty_sprite(),
    picture_on = util.empty_sprite(),
  },
  {
    type = "simple-entity-with-owner",
    name = "kr-inactive-shelter",
    localised_name = { "entity-name.kr-shelter" },
    localised_description = { "entity-description.kr-shelter" },
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    flags = {},
    hidden = true,
    collision_box = { { -2.75, -2.75 }, { 2.75, 2.75 } },
    selection_box = { { -3, -3 }, { 3, 3.20 } },
    minable = { mining_time = 10, result = "kr-shelter" },
    placeable_by = { item = "kr-shelter", count = 1 },
    picture = shelter_animation,
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
  },
})
