data:extend({
  {
    type = "recipe",
    name = "kr-big-storage-tank",
    energy_required = 5,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-steel-beam", amount = 10 },
      { type = "item", name = "steel-plate", amount = 20 },
      { type = "item", name = "kr-steel-pipe", amount = 4 },
    },
    results = { { type = "item", name = "kr-big-storage-tank", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-big-storage-tank",
    icon = "__Krastorio2Assets__/icons/entities/big-storage-tank.png",
    subgroup = "storage",
    order = "b[fluid]-bb2[storage-tank-2]",
    place_result = "kr-big-storage-tank",
    stack_size = 50,
  },
  {
    type = "storage-tank",
    name = "kr-big-storage-tank",
    icon = "__Krastorio2Assets__/icons/entities/big-storage-tank.png",
    flags = { "placeable-player", "player-creation" },
    minable = { mining_time = 0.5, result = "kr-big-storage-tank" },
    collision_box = { { -1.25, -1.25 }, { 1.25, 1.25 } },
    selection_box = { { -1.5, -1.5 }, { 1.5, 1.5 } },
    flow_length_in_ticks = 360,
    fluid_box = {
      volume = 50000,
      pipe_covers = pipecoverspictures(),
      pipe_connections = {
        {
          flow_direction = "input-output",
          direction = defines.direction.west,
          position = { -1, 0 },
        },
        {
          flow_direction = "input-output",
          direction = defines.direction.north,
          position = { 0, -1 },
        },
        {
          flow_direction = "input-output",
          direction = defines.direction.east,
          position = { 1, 0 },
        },
        {
          flow_direction = "input-output",
          direction = defines.direction.south,
          position = { 0, 1 },
        },
      },
    },
    max_health = 750,
    corpse = "big-remnants",
    resistances = {
      { type = "physical", percent = 35 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 50 },
    },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound = {
      sound = {
        filename = "__base__/sound/storage-tank.ogg",
        volume = 0.5,
      },
      max_sounds_per_prototype = 3,
    },
    pictures = {
      picture = {
        sheets = {
          {
            filename = "__Krastorio2Assets__/buildings/big-storage-tank/big-storage-tank.png",
            priority = "extra-high",
            frames = 1,
            scale = 0.5,
            width = 256,
            height = 256,
          },
          {
            filename = "__Krastorio2Assets__/buildings/big-storage-tank/big-storage-tank-sh.png",
            priority = "extra-high",
            frames = 1,
            scale = 0.5,
            width = 256,
            height = 256,
            shift = { 0.152, 0 },
            draw_as_shadow = true,
          },
        },
      },
      fluid_background = {
        filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
        priority = "extra-high",
        width = 32,
        height = 15,
      },
      window_background = {
        filename = "__base__/graphics/entity/storage-tank/window-background.png",
        priority = "extra-high",
        width = 17,
        height = 24,
      },
      flow_sprite = {
        filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
        priority = "extra-high",
        width = 160,
        height = 20,
      },
      gas_flow = {
        filename = "__base__/graphics/entity/pipe/steam.png",
        priority = "extra-high",
        line_length = 10,
        width = 48,
        height = 30,
        frame_count = 60,
        axially_symmetrical = false,
        animation_speed = 0.25,
        direction_count = 1,
      },
    },
    window_bounding_box = { { -0.125, 0.6875 }, { 0.1875, 1.1875 } },
    water_reflection = {
      pictures = {
        filename = "__Krastorio2Assets__/buildings/big-storage-tank/big-storage-tank-reflection.png",
        priority = "extra-high",
        width = 40,
        height = 35,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5,
      },
      rotate = false,
      orientation_to_variation = false,
    },
    circuit_connector = circuit_connector_definitions["storage-tank"],
    circuit_wire_max_distance = default_circuit_wire_max_distance,
  },
})
