local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-fuel-refinery",
    energy_required = 5,
    enabled = false,
    ingredients = {
      { type = "item", name = "steel-plate", amount = 5 },
      { type = "item", name = "iron-gear-wheel", amount = 5 },
      { type = "item", name = "electronic-circuit", amount = 5 },
      { type = "item", name = "pipe", amount = 5 },
    },
    results = { { type = "item", name = "kr-fuel-refinery", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-fuel-refinery",
    icon = "__Krastorio2Assets__/icons/entities/fuel-refinery.png",
    subgroup = "production-machine",
    order = "e[fuel-refinery]",
    place_result = "kr-fuel-refinery",
    stack_size = 50,
  },
  {
    type = "assembling-machine",
    name = "kr-fuel-refinery",
    icon = "__Krastorio2Assets__/icons/entities/fuel-refinery.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { hardness = 0.5, mining_time = 0.5, result = "kr-fuel-refinery" },
    max_health = 300,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = { { -1.2, -1.2 }, { 1.2, 1.2 } },
    selection_box = { { -1.5, -1.5 }, { 1.5, 1.5 } },
    drawing_box_vertical_extension = 0.4,
    module_slots = 3,
    allowed_effects = { "consumption", "speed", "productivity", "pollution" },
    crafting_speed = 1,
    ingredient_count = 4,
    crafting_categories = { "kr-fuel-refinery" },
    fluid_boxes = {
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { -1, -1 } } },
      },
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { 1, -1 } } },
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { -1, 1 } } },
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { 1, 1 } } },
      },
    },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 10 },
    },
    energy_usage = "250kW",
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = {
        filename = "__base__/sound/chemical-plant.ogg",
        volume = 0.5,
      },
      idle_sound = {
        filename = "__base__/sound/idle1.ogg",
        volume = 0.5,
      },
    },
    graphics_set = {
      animation = make_4way_animation_from_spritesheet({
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/fuel-refinery.png",
            width = 244,
            height = 268,
            frame_count = 1,
            shift = util.by_pixel(-5, -4.5),
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/fuel-refinery-shadow.png",
            width = 350,
            height = 219,
            frame_count = 1,
            shift = util.by_pixel(31.5, 10.75),
            draw_as_shadow = true,
            scale = 0.5,
          },
        },
      }),
      working_visualisations = {
        {
          north_position = util.by_pixel(30, -24),
          west_position = util.by_pixel(1, -49.5),
          south_position = util.by_pixel(-30, -48),
          east_position = util.by_pixel(-11, -1),
          apply_recipe_tint = "primary",
          animation = {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/boiling-green-patch.png",
            frame_count = 32,
            width = 30,
            height = 20,
            animation_speed = 0.5,
            scale = 0.5,
          },
        },
        {
          north_position = util.by_pixel(30, -24),
          west_position = util.by_pixel(1, -49.5),
          south_position = util.by_pixel(-30, -48),
          east_position = util.by_pixel(-11, -1),
          apply_recipe_tint = "secondary",
          animation = {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/boiling-green-patch-mask.png",
            frame_count = 32,
            width = 30,
            height = 20,
            animation_speed = 0.5,
            scale = 0.5,
          },
        },
        {
          apply_recipe_tint = "tertiary",
          north_position = { 0, 0 },
          west_position = { 0, 0 },
          south_position = { 0, 0 },
          east_position = { 0, 0 },
          north_animation = {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/boiling-window-green-patch.png",
            x = 0,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5,
          },
          east_animation = {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/boiling-window-green-patch.png",
            x = 174,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5,
          },
          south_animation = {
            filename = "__Krastorio2Assets__/buildings/fuel-refinery/boiling-window-green-patch.png",
            x = 348,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5,
          },
        },
      },
      water_reflection = {
        pictures = {
          filename = "__Krastorio2Assets__/buildings/fuel-refinery/fuel-refinery-reflection.png",
          priority = "extra-high",
          width = 44,
          height = 44,
          shift = util.by_pixel(0, 40),
          variation_count = 1,
          scale = 5,
        },
        rotate = false,
        orientation_to_variation = false,
      },
    },

    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions.create_vector(
      universal_connector_template, 
      {
        { variation = 0,  main_offset = util.by_pixel_hr(16, 88),  shadow_offset = util.by_pixel_hr(16, 90),  show_shadow = false },
        { variation = 26, main_offset = util.by_pixel_hr(-24, 72), shadow_offset = util.by_pixel_hr(-24, 72), show_shadow = false },
        { variation = 0,  main_offset = util.by_pixel_hr(24, -64), shadow_offset = util.by_pixel_hr(24, -64), show_shadow = false },
        { variation = 26, main_offset = util.by_pixel_hr(24, 80),  shadow_offset = util.by_pixel_hr(24, 80), show_shadow = false }
      }
    )
  },
})
