local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-energy-storage",
    energy_required = 30,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-steel-beam", amount = 10 },
      { type = "item", name = "processing-unit", amount = 10 },
      { type = "item", name = "kr-rare-metals", amount = 50 },
      { type = "item", name = "kr-energy-control-unit", amount = 50 },
    },
    results = { { type = "item", name = "kr-energy-storage", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-energy-storage",
    icon = "__Krastorio2Assets__/icons/entities/energy-storage.png",
    subgroup = "energy",
    order = "e[accumulator]-b[energy-storage]",
    place_result = "kr-energy-storage",
    stack_size = 50,
  },
  {
    type = "accumulator",
    name = "kr-energy-storage",
    icon = "__Krastorio2Assets__/icons/entities/energy-storage.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 1, result = "kr-energy-storage" },
    max_health = 750,
    corpse = "big-remnants",
    dying_explosion = "big-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    collision_box = { { -2.75, -2.75 }, { 2.75, 2.75 } },
    selection_box = { { -3, -3 }, { 3, 3 } },
    drawing_box_vertical_extension = 0.25,
    resistances = {
      { type = "physical", percent = 25 },
      { type = "fire", percent = 25 },
      { type = "impact", percent = 50 },
    },
    charge_cooldown = 5,
    discharge_cooldown = 5,
    default_output_signal = { type = "virtual", name = "signal-A" },
    energy_source = {
      type = "electric",
      buffer_capacity = "250MJ",
      usage_priority = "tertiary",
      input_flow_limit = "5MW",
      output_flow_limit = "5MW",
    },
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = {
        filename = "__Krastorio2Assets__/sounds/buildings/energy-storage-working.ogg",
        volume = 0.9,
      },
      idle_sound = {
        filename = "__base__/sound/accumulator-idle.ogg",
        volume = 0.8,
      },
      max_sounds_per_prototype = 2,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
    },
    chargable_graphics = {
      picture = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 1,
            shift = { 0, -0.4 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-sh.png",
            width = 414,
            height = 270,
            scale = 0.55,
            frame_count = 1,
            draw_as_shadow = true,
            shift = { 0.72, 0.56 },
          },
        },
      },
      charge_animation = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.03,
            shift = { 0, -0.4 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-sh.png",
            width = 414,
            height = 270,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.03,
            draw_as_shadow = true,
            shift = { 0.72, 0.56 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-charge.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 2,
            line_length = 2,
            animation_speed = 0.03,
            shift = { 0, -0.4 },
            draw_as_glow = true,
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-light.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.06,
            shift = { 0, -0.4 },
            draw_as_light = true,
          },
        },
      },
      discharge_animation = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.06,
            shift = { 0, -0.4 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-sh.png",
            width = 414,
            height = 270,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.06,
            draw_as_shadow = true,
            shift = { 0.72, 0.56 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-discharge.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 2,
            line_length = 2,
            animation_speed = 0.06,
            shift = { 0, -0.4 },
            draw_as_glow = true,
          },
          {
            filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-light.png",
            width = 380,
            height = 380,
            scale = 0.55,
            frame_count = 1,
            repeat_count = 2,
            animation_speed = 0.06,
            shift = { 0, -0.4 },
            draw_as_light = true,
          },
        },
      },
    },
    water_reflection = {
      pictures = {
        filename = "__Krastorio2Assets__/buildings/energy-storage/energy-storage-reflection.png",
        priority = "extra-high",
        width = 44,
        height = 44,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5,
      },
      rotate = false,
      orientation_to_variation = false,
    },
    circuit_connector = circuit_connector_definitions["accumulator"],
    circuit_wire_max_distance = default_circuit_wire_max_distance,
  },
})
