local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-antimatter-reactor",
    energy_required = 300,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-ai-core", amount = 50 },
      { type = "item", name = "kr-energy-control-unit", amount = 50 },
      { type = "item", name = "kr-imersium-beam", amount = 100 },
      { type = "item", name = "kr-imersium-plate", amount = 350 },
      { type = "item", name = "kr-rare-metals", amount = 350 },
      { type = "item", name = "steel-plate", amount = 350 },
    },
    results = { { type = "item", name = "kr-antimatter-reactor", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-antimatter-reactor",
    icon = "__Krastorio2Assets__/icons/entities/antimatter-reactor.png",
    subgroup = "energy",
    order = "z-h[antimatter-reactor]-c[antimatter-reactor]",
    place_result = "kr-antimatter-reactor",
    stack_size = 1,
  },
  {
    type = "burner-generator",
    name = "kr-antimatter-reactor",
    icon = "__Krastorio2Assets__/icons/entities/antimatter-reactor.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 2, result = "kr-antimatter-reactor" },
    max_health = 5000,
    damaged_trigger_effect = hit_effects.entity(),
    corpse = "kr-antimatter-reactor-remnant",
    dying_explosion = "kr-large-matter-explosion",
    resistances = {
      { type = "physical", percent = 60 },
      { type = "fire", percent = 90 },
      { type = "impact", percent = 90 },
    },
    collision_box = { { -4.75, -4.75 }, { 4.75, 4.75 } },
    selection_box = { { -4.95, -4.95 }, { 4.95, 4.95 } },
    fluid_box = {
      production_type = "input",
      volume = 100,
      pipe_connections = { { flow_direction = "input", direction = defines.direction.east, position = { 4, 0 } } },
    },
    energy_source = {
      type = "electric",
      render_no_power_icon = false,
      usage_priority = "secondary-output",
    },
    burner = {
      type = "burner",
      fuel_categories = { "kr-antimatter-fuel" },
      fuel_inventory_size = 1,
      burnt_inventory_size = 1,
      effectivity = 1,
      emissions_per_minute = { pollution = 200 },
      light_flicker = {
        minimum_intensity = 0.01,
        maximum_intensity = 0.50,
        derivation_change_frequency = 0.02,
        derivation_change_deviation = 0.02,
        minimum_light_size = 1,
        color = { r = 0.459, g = 0.031, b = 0.447 },
      },
    },
    max_power_output = "3000MW",
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = { { filename = "__Krastorio2Assets__/sounds/buildings/antimatter-reactor.ogg", volume = 1.25 } },
    },
    open_sound = { filename = "__Krastorio2Assets__/sounds/buildings/open.ogg", volume = 1 },
    close_sound = { filename = "__Krastorio2Assets__/sounds/buildings/close.ogg", volume = 1 },
    min_perceived_performance = 0.25,
    performance_to_sound_speedup = 0.5,
    animation = {
      layers = {
        {
          filename = "__Krastorio2Assets__/buildings/antimatter-reactor/antimatter-reactor-light.png",
          priority = "high",
          width = 660,
          height = 706,
          shift = { 0, -0.5 },
          frame_count = 1,
          repeat_count = 30,
          animation_speed = 0.9,
          scale = 0.5,
          draw_as_light = true,
          blend_mode = "additive",
        },
        {
          filename = "__Krastorio2Assets__/buildings/antimatter-reactor/antimatter-reactor-glow.png",
          priority = "high",
          width = 660,
          height = 706,
          shift = { 0, -0.5 },
          frame_count = 1,
          repeat_count = 30,
          animation_speed = 0.9,
          scale = 0.5,
          blend_mode = "additive-soft",
          draw_as_glow = true,
          fadeout = true,
        },
        {
          filename = "__Krastorio2Assets__/buildings/antimatter-reactor/antimatter-reactor.png",
          priority = "high",
          width = 660,
          height = 706,
          shift = { 0, -0.5 },
          repeat_count = 30,
          animation_speed = 0.9,
          scale = 0.5,
        },
        {
          filename = "__Krastorio2Assets__/buildings/antimatter-reactor/antimatter-reactor-anim.png",
          priority = "high",
          width = 660,
          height = 706,
          shift = { 0, -0.5 },
          frame_count = 30,
          line_length = 6,
          animation_speed = 0.9,
          scale = 0.5,
        },
        {
          filename = "__Krastorio2Assets__/buildings/antimatter-reactor/antimatter-reactor-sh.png",
          width = 724,
          height = 630,
          shift = { 0.57, 0.27 },
          frame_count = 1,
          repeat_count = 30,
          animation_speed = 0.9,
          scale = 0.5,
          draw_as_shadow = true,
        },
      },
    },
  },
})
