data:extend({
  {
    type = "recipe",
    name = "kr-crush-bulk-inserter",
    icon = "__Krastorio2Assets__/icons/items/electronic-components.png",
    subgroup = "intermediate-product",
    order = "e[ei-electronic-components]",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "bulk-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
      { type = "item", name = "kr-electronic-components", amount = 2 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-burner-inserter",
    category = "kr-crushing",
    hide_from_player_crafting = true,
    enabled = true,
    energy_required = 1,
    ingredients = {
      { type = "item", name = "burner-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-fast-inserter",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "fast-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-imersite-crystal",
    -- TODO: Make new icon with imersite crystal and crushing overlay
    icon = "__Krastorio2Assets__/icons/items/imersite-powder.png",
    subgroup = "intermediate-product",
    order = "e[ei-electronic-components]",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "kr-imersite-crystal", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-imersite-powder", amount = 3 },
    },
    main_product = "",
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-imersite-powder",
    icon = "__Krastorio2Assets__/icons/items/imersite-powder.png",
    enabled = false,
    category = "kr-crushing",
    energy_required = 3,
    ingredients = {
      { type = "item", name = "kr-imersite", amount = 3 },
    },
    results = {
      { type = "item", name = "kr-imersite-powder", amount = 3 },
      { type = "item", name = "kr-sand", amount = 3 },
    },
    main_product = "kr-imersite-powder",
    allow_as_intermediate = false,
    allow_intermediates = false,
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-inserter",
    factoriopedia_alternative = "kr-inserter-parts",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-long-handed-inserter",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "long-handed-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-sand",
    enabled = false,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "stone", amount = 3 },
    },
    results = {
      { type = "item", name = "kr-sand", amount_min = 7, amount_max = 8 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-superior-inserter",
    icon = "__Krastorio2Assets__/icons/items/electronic-components.png",
    subgroup = "intermediate-product",
    order = "e[ei-electronic-components]",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "kr-superior-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
      { type = "item", name = "kr-electronic-components", amount = 4 },
      { type = "item", name = "kr-imersite-powder", amount = 3 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
  {
    type = "recipe",
    name = "kr-crush-superior-long-inserter",
    icon = "__Krastorio2Assets__/icons/items/electronic-components.png",
    subgroup = "intermediate-product",
    order = "e[ei-electronic-components]",
    hide_from_player_crafting = true,
    enabled = true,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "kr-superior-long-inserter", amount = 1 },
    },
    results = {
      { type = "item", name = "kr-inserter-parts", amount = 1 },
      { type = "item", name = "kr-electronic-components", amount = 4 },
      { type = "item", name = "kr-imersite-powder", amount = 6 },
    },
    allow_as_intermediate = false,
    allow_intermediates = false,
    always_show_made_in = true,
    always_show_products = true,
  },
})
