local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "optimized-particle",
    name = "kr-virus-capsule-metal-particle",
    life_time = 15 * second,
    render_layer = "projectile",
    render_layer_when_on_ground = "corpse",
    regular_trigger_effect = {
      type = "create-trivial-smoke",
      smoke_name = "kr-poison-capsule-particle-smoke",
      starting_frame_deviation = 0,
      starting_frame_speed_deviation = 0,
      offset_deviation = { { -0.03, -0.03 }, { 0.03, 0.03 } },
      speed_from_center = nil,
    },
    regular_trigger_effect_frequency = 2,
    ended_in_water_trigger_effect = {
      {
        type = "create-particle",
        probability = 1,
        affects_target = false,
        show_in_tooltip = false,
        particle_name = "tintable-water-particle",
        offset_deviation = { { -0.05, -0.05 }, { 0.05, 0.05 } },
        tile_collision_mask = nil,
        initial_height = 0,
        initial_height_deviation = 0.02,
        initial_vertical_speed = 0.05,
        initial_vertical_speed_deviation = 0.05,
        speed_from_center = 0.01,
        speed_from_center_deviation = 0.006,
        frame_speed = 1,
        frame_speed_deviation = 0,
        tail_length = 2,
        tail_length_deviation = 1,
        tail_width = 3,
      },
      {
        type = "create-particle",
        repeat_count = 10,
        repeat_count_deviation = 6,
        probability = 0.03,
        affects_target = false,
        show_in_tooltip = false,
        particle_name = "tintable-water-particle",
        offsets = {
          { 0, 0 },
          { 0.01563, -0.09375 },
          { 0.0625, 0.09375 },
          { -0.1094, 0.0625 },
        },
        offset_deviation = { { -0.2969, -0.1992 }, { 0.2969, 0.1992 } },
        tile_collision_mask = nil,
        initial_height = 0,
        initial_height_deviation = 0.02,
        initial_vertical_speed = 0.053,
        initial_vertical_speed_deviation = 0.005,
        speed_from_center = 0.02,
        speed_from_center_deviation = 0.006,
        frame_speed = 1,
        frame_speed_deviation = 0,
        tail_length = 9,
        tail_length_deviation = 0,
        tail_width = 1,
      },
      {
        type = "play-sound",
        sound = sounds.small_splash,
      },
    },
    pictures = {
      sheet = {
        filename = "__base__/graphics/particle/metal-particle/metal-particle-small.png",
        priority = "extra-high",
        width = 20,
        height = 16,
        frame_count = 12,
        animation_speed = 0.5,
        variation_count = 10,
        shift = util.by_pixel(2.25, -0.25),
        scale = 0.5,
      },
    },
    shadows = {
      sheet = {
        filename = "__base__/graphics/particle/metal-particle/metal-particle-small.png",
        priority = "extra-high",
        width = 20,
        height = 16,
        tint = shadowtint(),
        frame_count = 12,
        animation_speed = 0.5,
        variation_count = 10,
        shift = util.by_pixel(3.25, -0.25),
        scale = 0.5,
      },
    },
  },
})
