data:extend({
  {
    type = "recipe",
    name = "kr-vehicle-roboport-equipment",
    enabled = false,
    energy_required = 10,
    ingredients = {
      { type = "item", name = "personal-roboport-equipment", amount = 2 },
      { type = "item", name = "steel-plate", amount = 4 },
      { type = "item", name = "advanced-circuit", amount = 1 },
    },
    results = { { type = "item", name = "kr-vehicle-roboport-equipment", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-vehicle-roboport-equipment",
    icon = "__Krastorio2Assets__/icons/equipment/vehicle-roboport-equipment.png",
    place_as_equipment_result = "kr-vehicle-roboport-equipment",
    subgroup = "kr-vehicle-motor",
    order = "e[additional-engines]-f1[vehicle-roboport-equipment]",
    stack_size = 5,
  },
  {
    type = "roboport-equipment",
    name = "kr-vehicle-roboport-equipment",
    take_result = "kr-vehicle-roboport-equipment",
    sprite = {
      filename = "__Krastorio2Assets__/equipment/vehicle-roboport-equipment.png",
      width = 256,
      height = 256,
      scale = 0.5,
      priority = "medium",
    },
    shape = {
      type = "full",
      width = 4,
      height = 4,
    },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "250MJ",
      input_flow_limit = "50MW",
    },
    charging_energy = "2500kW",
    robot_limit = 100,
    construction_radius = 48,
    spawn_and_station_height = 0.4,
    charge_approach_distance = 2.6,
    recharging_animation = {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      width = 37,
      height = 35,
      frame_count = 16,
      animation_speed = 0.5,
      scale = 1.5,
      priority = "high",
    },
    recharging_light = { intensity = 0.4, size = 5 },
    stationing_offset = { 0, -0.6 },
    charging_station_shift = { 0, 0.5 },
    charging_station_count = 12,
    charging_distance = 2,
    charging_threshold_distance = 6,
    categories = { "kr-vehicle-roboport" },
  },
})
