local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-steel-pump",
    energy_required = 2,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-steel-gear-wheel", amount = 4 },
      { type = "item", name = "engine-unit", amount = 1 },
      { type = "item", name = "kr-steel-beam", amount = 1 },
      { type = "item", name = "kr-steel-pipe", amount = 1 },
    },
    results = { { type = "item", name = "kr-steel-pump", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-steel-pump",
    icon = "__Krastorio2Assets__/icons/entities/steel-pump.png",
    subgroup = "energy-pipe-distribution",
    order = "b[pipe]-ca[steel-pump]",
    place_result = "kr-steel-pump",
    stack_size = 50,
  },
  {
    type = "pump",
    name = "kr-steel-pump",
    icon = "__Krastorio2Assets__/icons/entities/steel-pump.png",
    flags = { "placeable-neutral", "player-creation" },
    minable = { mining_time = 0.2, result = "kr-steel-pump" },
    fast_replaceable_group = "pump",
    collision_box = { { -0.29, -0.9 }, { 0.29, 0.9 } },
    selection_box = { { -0.5, -1 }, { 0.5, 1 } },
    pumping_speed = 50,
    fluid_box = {
      volume = 500,
      pipe_covers = require("prototypes.buildings.steel-pipe-covers"),
      pipe_connections = {
        {
          flow_direction = "output",
          direction = defines.direction.north,
          position = { 0, -0.5 },
        },
        {
          flow_direction = "input",
          direction = defines.direction.south,
          position = { 0, 0.5 },
        },
      },
    },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
    },
    energy_usage = "50kW",
    max_health = 180,
    resistances = {
      {
        type = "fire",
        percent = 80,
      },
      {
        type = "impact",
        percent = 30,
      },
    },
    corpse = "1x2-remnants",
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    working_sound = data.raw.pump.pump.working_sound,
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    animations = {
      north = {
        filename = "__Krastorio2Assets__/buildings/steel-pump/steel-pump-north.png",
        width = 103,
        height = 164,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        animation_speed = 0.5,
        shift = util.by_pixel(8, 3.5), -- {0.515625, 0.21875}
      },
      east = {
        filename = "__Krastorio2Assets__/buildings/steel-pump/steel-pump-east.png",
        width = 130,
        height = 109,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        animation_speed = 0.5,
        shift = util.by_pixel(-0.5, 1.75), --{-0.03125, 0.109375}
      },
      south = {
        filename = "__Krastorio2Assets__/buildings/steel-pump/steel-pump-south.png",
        width = 114,
        height = 160,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        animation_speed = 0.5,
        shift = util.by_pixel(12.5, -8), -- {0.75, -0.5}
      },
      west = {
        filename = "__Krastorio2Assets__/buildings/steel-pump/steel-pump-west.png",
        width = 131,
        height = 111,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        animation_speed = 0.5,
        shift = util.by_pixel(-0.25, 1.25), -- {-0.015625, 0.078125}
      },
    },
    fluid_wagon_connector_frame_count = 35,
    fluid_wagon_connector_alignment_tolerance = 2.0 / 32.0,
    fluid_wagon_connector_graphics = {
      load_animations = {
        west = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-load-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-1-load-standup-base-shadow.png",
              width = 157,
              height = 136,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-8.75, 8.5),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-load-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-2-load-standup-shadow.png",
              width = 155,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-6.75, -13.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-2-load-connect-shadow.png",
              width = 169,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.75, -10),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-load-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-3-load-connect-shadow.png",
              width = 171,
              height = 175,
              scale = 0.5,
              line_length = 1,
              frame_count = 17,
              shift = util.by_pixel(-27.75, 12.75),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-load-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-4-load-standup-shadow.png",
              width = 168,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-6.5, -13.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-4-load-connect-shadow.png",
              width = 168,
              height = 144,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.5, -14),
            },
          },
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-load-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-5-load-standup-shadow.png",
              width = 168,
              height = 157,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-6.5, 3.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-5-load-connect-shadow.png",
              width = 172,
              height = 158,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.5, 9),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-load-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-6-load-standup-shadow.png",
              width = 170,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-7, -13.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-6-load-connect-shadow.png",
              width = 174,
              height = 131,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27, -16.75),
            },
          },
        },
        north = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-1-load-standup-shadow.png",
              width = 126,
              height = 158,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(18, -52),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-1-load-connect-shadow.png",
              width = 129,
              height = 181,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(26.75, -66.25),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-2-load-standup-shadow.png",
              width = 133,
              height = 180,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -47.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-2-load-connect-shadow.png",
              width = 143,
              height = 178,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(16.25, -65),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-3-load-standup-shadow.png",
              width = 133,
              height = 180,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -47.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-3-load-connect-shadow.png",
              width = 103,
              height = 181,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(20.25, -66.25),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
          },
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-5-load-standup-shadow.png",
              width = 133,
              height = 181,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -47.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-5-load-connect-shadow.png",
              width = 103,
              height = 177,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(20.25, -67.25),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-load-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-6-load-standup-shadow.png",
              width = 133,
              height = 182,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -48),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-6-load-connect-shadow.png",
              width = 143,
              height = 178,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(16.25, -65),
            },
          },
        },
        east = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-load-standup-base.png",
              width = 110,
              height = 127,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -16.25),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-2-load-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -24.5),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-load-standup-base.png",
              width = 110,
              height = 127,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -16.25),
            },
          },
          [4] = {},
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-load-standup-base.png",
              width = 110,
              height = 127,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -16.25),
            },
          },
          [6] = {},
        },
        south = {
          [1] = {},
          [2] = {},
          [3] = {},
          [4] = {},
          [5] = {},
          [6] = {},
        },
      },
      unload_animations = {
        west = {
          [1] = {
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-unload-standup-top.png",
              width = 123,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.25, -31.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-1-unload-standup-shadow.png",
              width = 106,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(33.5, 4.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-1-unload-connect.png",
              width = 106,
              height = 119,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(46, -22.25),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-1-unload-connect-shadow.png",
              width = 92,
              height = 90,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(61, -2),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -24.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.75, -41.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-2-unload-standup-shadow.png",
              width = 96,
              height = 163,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(31, -16.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-2-unload-connect.png",
              width = 107,
              height = 102,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(45.25, -49.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-2-unload-connect-shadow.png",
              width = 88,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(57, -40.5),
            },
          },
          [3] = {
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-unload-standup-top.png",
              width = 123,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.25, -31.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-3-unload-standup-shadow.png",
              width = 96,
              height = 142,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(31, -1.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-3-unload-connect.png",
              width = 106,
              height = 105,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(45, -25.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-3-unload-connect-shadow.png",
              width = 80,
              height = 78,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(56.5, -18.5),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -24.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.75, -41.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-4-unload-standup-shadow.png",
              width = 95,
              height = 163,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(30.75, -15.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-4-unload-connect.png",
              width = 109,
              height = 87,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(45.75, -51.75),
            },
          },
          [5] = {
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-135-unload-standup-top.png",
              width = 123,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.25, -31.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-5-unload-standup-shadow.png",
              width = 100,
              height = 158,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(32, 0.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-5-unload-connect.png",
              width = 108,
              height = 90,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(46, -29.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-5-unload-connect-shadow.png",
              width = 86,
              height = 84,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(54, -17),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(23.5, -24.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(18.75, -41.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-6-unload-standup-shadow.png",
              width = 145,
              height = 161,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(43.25, -16.25),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-L-6-unload-connect.png",
              width = 107,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(45.25, -55),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-L-6-unload-connect-shadow.png",
              width = 86,
              height = 132,
              scale = 0.5,
              line_length = 1,
              frame_count = 18,
              shift = util.by_pixel(55.5, -17.5),
            },
          },
        },
        north = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-1-unload-standup-shadow.png",
              width = 76,
              height = 61,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(2.5, 18.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-135-unload-connect.png",
              width = 89,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(3.75, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-1-unload-connect-shadow.png",
              width = 101,
              height = 53,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(9.75, 16.75),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-2-unload-standup-shadow.png",
              width = 86,
              height = 60,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(4.5, 18.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-246-unload-connect.png",
              width = 76,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-1.5, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-2-unload-connect-shadow.png",
              width = 97,
              height = 66,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(5.25, 20),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-3-unload-standup-shadow.png",
              width = 78,
              height = 40,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(2.5, 13.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-135-unload-connect.png",
              width = 89,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(3.75, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-3-unload-connect-shadow.png",
              width = 102,
              height = 54,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(9.5, 17),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-4-unload-standup-shadow.png",
              width = 86,
              height = 61,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(4.5, 18.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-246-unload-connect.png",
              width = 76,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-1.5, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-4-unload-connect-shadow.png",
              width = 97,
              height = 80,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(5.25, 23.5),
            },
          },
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-5-unload-standup-shadow.png",
              width = 78,
              height = 40,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(2.5, 13.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-135-unload-connect.png",
              width = 89,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(3.75, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-5-unload-connect-shadow.png",
              width = 99,
              height = 54,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(10.25, 17),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-base.png",
              width = 91,
              height = 107,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, 15.75),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-123456-unload-standup-top.png",
              width = 46,
              height = 109,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, 0.75),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-6-unload-standup-shadow.png",
              width = 134,
              height = 115,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.5, 0.25),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-T-246-unload-connect.png",
              width = 76,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-1.5, 0.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-T-6-unload-connect-shadow.png",
              width = 81,
              height = 66,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(1.25, -12),
            },
          },
        },
        east = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-top.png",
              width = 121,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -29),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-1-unload-connect.png",
              width = 107,
              height = 115,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-43.25, -20.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-1-unload-connect-shadow.png",
              width = 168,
              height = 153,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27, 17.75),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -39),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-2-unload-standup-shadow.png",
              width = 163,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-7.75, -13.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-2-unload-connect.png",
              width = 107,
              height = 96,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-42.75, -47),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-2-unload-connect-shadow.png",
              width = 169,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.75, -10),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-top.png",
              width = 121,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -29),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-3-unload-standup-shadow.png",
              width = 160,
              height = 157,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-7, 3.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-3-unload-connect.png",
              width = 106,
              height = 99,
              scale = 0.5,
              line_length = 1,
              frame_count = 17,
              shift = util.by_pixel(-44, -24.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-3-unload-connect-shadow.png",
              width = 171,
              height = 175,
              scale = 0.5,
              line_length = 1,
              frame_count = 17,
              shift = util.by_pixel(-27.75, 12.75),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -39),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-4-unload-standup-shadow.png",
              width = 163,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-7.75, -13.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-4-unload-connect.png",
              width = 105,
              height = 80,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-43.75, -50),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-4-unload-connect-shadow.png",
              width = 168,
              height = 144,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.5, -14),
            },
          },
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-base.png",
              width = 110,
              height = 126,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -13.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-135-unload-standup-top.png",
              width = 121,
              height = 70,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -29),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-5-unload-standup-shadow.png",
              width = 163,
              height = 157,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-7.75, 3.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-5-unload-connect.png",
              width = 106,
              height = 82,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-44, -27.5),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-5-unload-connect-shadow.png",
              width = 172,
              height = 158,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27.5, 9),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-base.png",
              width = 110,
              height = 148,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-23.5, -21.5),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-246-unload-standup-top.png",
              width = 121,
              height = 110,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(-18.75, -39),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-6-unload-standup-shadow.png",
              width = 165,
              height = 162,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-8.25, -13.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/V-R-6-unload-connect.png",
              width = 106,
              height = 63,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-44, -53.75),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/V-R-6-unload-connect-shadow.png",
              width = 174,
              height = 133,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-27, -16.25),
            },
          },
        },
        south = {
          [1] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-1-unload-standup-shadow.png",
              width = 133,
              height = 172,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -49.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-135-unload-connect.png",
              width = 78,
              height = 100,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(4.5, -103),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-1-unload-connect-shadow.png",
              width = 81,
              height = 118,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(14.75, -82),
            },
          },
          [2] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-2-unload-standup-shadow.png",
              width = 125,
              height = 173,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(18.75, -49.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-246-unload-connect.png",
              width = 74,
              height = 95,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-3.5, -103.25),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-2-unload-connect-shadow.png",
              width = 143,
              height = 178,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(16.25, -65),
            },
          },
          [3] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-3-unload-standup-shadow.png",
              width = 133,
              height = 172,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -49.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-135-unload-connect.png",
              width = 78,
              height = 100,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(4.5, -103),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-3-unload-connect-shadow.png",
              width = 130,
              height = 177,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(27, -67.25),
            },
          },
          [4] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-4-unload-standup-shadow.png",
              width = 133,
              height = 172,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -49.5),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-246-unload-connect.png",
              width = 74,
              height = 95,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-3.5, -103.25),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-4-unload-connect-shadow.png",
              width = 143,
              height = 178,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(16.25, -65),
            },
          },
          [5] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-5-unload-standup-shadow.png",
              width = 133,
              height = 173,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(16.75, -49.75),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-135-unload-connect.png",
              width = 78,
              height = 100,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(4.5, -103),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-5-unload-connect-shadow.png",
              width = 103,
              height = 177,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(20.25, -67.25),
            },
          },
          [6] = {
            standup_base = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-base.png",
              width = 91,
              height = 160,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(-0.25, -62),
            },
            standup_top = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-123456-unload-standup-top.png",
              width = 46,
              height = 146,
              scale = 0.5,
              line_length = 1,
              frame_count = 19,
              shift = util.by_pixel(0, -72.5),
            },
            standup_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-6-unload-standup-shadow.png",
              width = 134,
              height = 174,
              scale = 0.5,
              line_length = 1,
              frame_count = 20,
              shift = util.by_pixel(17, -50),
            },
            connector = {
              filename = "__Krastorio2Assets__/buildings/steel-pump/connector/H-B-246-unload-connect.png",
              width = 74,
              height = 95,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(-3.5, -103.25),
            },
            connector_shadow = {
              filename = "__base__/graphics/entity/pump/connector/H-B-6-unload-connect-shadow.png",
              width = 144,
              height = 178,
              scale = 0.5,
              line_length = 1,
              frame_count = 16,
              shift = util.by_pixel(16.5, -65),
            },
          },
        },
      },
    },
    fluid_animation = {
      north = {
        filename = "__base__/graphics/entity/pump/pump-north-liquid.png",
        apply_runtime_tint = true,
        width = 38,
        height = 22,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        shift = util.by_pixel(-0.250, -16.750),
      },
      east = {
        filename = "__base__/graphics/entity/pump/pump-east-liquid.png",
        width = 35,
        height = 46,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        shift = util.by_pixel(6.250, -8.500),
      },
      south = {
        filename = "__base__/graphics/entity/pump/pump-south-liquid.png",
        width = 38,
        height = 45,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        shift = util.by_pixel(0.500, -9.250),
      },
      west = {
        filename = "__base__/graphics/entity/pump/pump-west-liquid.png",
        width = 35,
        height = 47,
        scale = 0.5,
        line_length = 8,
        frame_count = 32,
        shift = util.by_pixel(-6.500, -9.500),
      },
    },
    glass_pictures = {
      north = {
        filename = "__base__/graphics/entity/pump/pump-north-glass.png",
        width = 64,
        height = 128,
        scale = 0.5,
      },
      east = {
        filename = "__base__/graphics/entity/pump/pump-east-glass.png",
        width = 128,
        height = 192,
        scale = 0.5,
      },
      south = {
        filename = "__base__/graphics/entity/pump/pump-south-glass.png",
        width = 64,
        height = 128,
        scale = 0.5,
      },
      west = {
        filename = "__base__/graphics/entity/pump/pump-west-glass.png",
        width = 192,
        height = 192,
        scale = 0.5,
        shift = util.by_pixel(-16.000, 0.000),
      },
    },
    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions["pump"]
  },
})

-- todo: base's pump has the north connector as part of the texture, k2's currently does not, remove this code when it does.
for _, direction in pairs({"north", "south"}) do
  data.raw.pump["kr-steel-pump"].animations[direction].layers = {
    {
      filename = "__Krastorio2Assets__/buildings/steel-pipe-covers/steel-pipe-cover-north.png",
      priority = "extra-high",
      width = 128,
      height = 128,
      scale = 0.5,
      shift = {0, -1.5},
      repeat_count = 32,
    },
    {
      filename = "__base__/graphics/entity/pipe-covers/pipe-cover-north-shadow.png",
      priority = "extra-high",
      width = 128,
      height = 128,
      scale = 0.5,
      draw_as_shadow = true,
      shift = {0, -1.5},
      repeat_count = 32,
    },
    table.deepcopy(data.raw.pump["kr-steel-pump"].animations[direction]) -- crashes to desktop without deepcopy
  }
end

if mods["Mini_Trains"] then
  data.raw.pump["kr-steel-pump"].fluid_wagon_connector_alignment_tolerance = (2 / 32) * 10
end
