local color_mapping = {
  white = { r = 1, g = 1, b = 1, a = 1 },
  yellow = { r = 0.9, g = 0.7, b = 0, a = 0.75 },
  olive = { r = 0.50, g = 0.60, b = 0.2, a = 0.5 },
  pink = { r = 1, g = 0.75, b = 0.3, a = 0.5 },
  red = { r = 1, g = 0.3, b = 0.3, a = 1 },
  blue = { r = 0.20, g = 0.25, b = 0.75, a = 0.75 },
  green = { r = 0.2, g = 0.8, b = 0.2, a = 0.8 },
  cyan = { r = 0.6, g = 1, b = 1, a = 1 },
  purple = { r = 0.45, g = 0.25, b = 0.7, a = 0.72 },
  gray = { r = 0.2, g = 0.2, b = 0.2, a = 0.8 },
}
local color_name = settings.startup["kr-shelter-tint"].value --[[@as string]]
local shelter_tint = color_mapping[color_name]
assert(shelter_tint, "invalid shelter tint: " .. color_name)

local animation = {
  layers = {
    {
      filename = "__Krastorio2Assets__/buildings/shelter-plus/shelter-plus-light.png",
      priority = "high",
      width = 450,
      height = 450,
      scale = 0.45,
      shift = { 0, -0.15 },
      draw_as_light = true,
      repeat_count = 6,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter-plus/shelter-plus.png",
      priority = "high",
      width = 450,
      height = 450,
      scale = 0.45,
      shift = { 0, -0.15 },
      repeat_count = 6,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter-plus/shelter-plus-anim.png",
      priority = "high",
      width = 450,
      height = 450,
      scale = 0.45,
      shift = { 0, -0.15 },
      frame_count = 6,
      line_length = 3,
      animation_speed = 0.5,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter-plus/shelter-plus-sh.png",
      priority = "high",
      width = 520,
      height = 342,
      scale = 0.45,
      shift = { 0.54, 0.46 },
      repeat_count = 6,
      animation_speed = 0.5,
      draw_as_shadow = true,
    },
    {
      filename = "__Krastorio2Assets__/buildings/shelter-plus/shelter-plus-mask.png",
      flags = { "mask" },
      priority = "extra-high",
      width = 450,
      height = 450,
      scale = 0.45,
      shift = { 0, -0.15 },
      repeat_count = 6,
      animation_speed = 0.5,
      apply_runtime_tint = true,
      tint = shelter_tint,
    },
  },
}

data:extend({
  {
    type = "item",
    name = "kr-shelter-plus",
    icon = "__Krastorio2Assets__/icons/entities/shelter-plus.png",
    subgroup = "storage",
    order = "aaa",
    place_result = "kr-shelter-plus-container",
    stack_size = 1,
  },
  {
    type = "electric-energy-interface",
    name = "kr-shelter-plus",
    localised_description = { "entity-description.kr-shelter-plus" },
    icon = "__Krastorio2Assets__/icons/entities/shelter-plus.png",
    allow_copy_paste = false,
    flags = { "not-on-map" },
    hidden = true,
    fast_replaceable_group = "kr-shelter-plus",
    minable = { mining_time = 0.5, result = "kr-shelter-plus" },
    collision_box = { { -2.72, -2.72 }, { 2.72, 2.72 } },
    selection_box = { { 0, 0 }, { 0, 0 } },
    energy_source = {
      type = "electric",
      buffer_capacity = "250kJ",
      usage_priority = "primary-output",
      input_flow_limit = "0kW",
      output_flow_limit = "250kW",
      render_no_power_icon = false,
      render_no_network_icon = false,
    },
    energy_production = "250kW",
  },
  {
    type = "container",
    name = "kr-shelter-plus-container",
    localised_name = { "entity-name.kr-shelter-plus" },
    localised_description = { "entity-description.kr-shelter-plus" },
    icon = "__Krastorio2Assets__/icons/entities/shelter-plus.png",
    flags = { "not-blueprintable", "player-creation" },
    minable = { mining_time = 0.5, result = "kr-shelter-plus" },
    allow_copy_paste = false,
    inventory_size = 200,
    max_health = 5000,
    corpse = "kr-medium-random-pipes-remnant",
    collision_box = { { -2.75, -2.75 }, { 2.75, 2.75 } },
    selection_box = { { -3, -3 }, { 3, 3 } },
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    open_sound = { filename = "__Krastorio2Assets__/sounds/buildings/open.ogg", volume = 1 },
    close_sound = { filename = "__Krastorio2Assets__/sounds/buildings/close.ogg", volume = 1 },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture = animation,
    water_reflection = {
      pictures = {
        filename = "__Krastorio2Assets__/buildings/shelter/shelter-reflection.png",
        priority = "extra-high",
        width = 60,
        height = 50,
        shift = util.by_pixel(0, 40),
        variation_count = 1,
        scale = 5,
      },
      rotate = false,
      orientation_to_variation = false,
    },
  },
  {
    type = "lamp",
    name = "kr-shelter-plus-light",
    localised_name = { "entity-name.kr-shelter-plus" },
    localised_description = { "entity-description.kr-shelter-plus" },
    icon = "__Krastorio2Assets__/icons/entities/shelter-plus.png",
    allow_copy_paste = false,
    flags = { "not-on-map" },
    hidden = true,
    collision_box = { { 0, 0 }, { 0, 0 } },
    selection_box = { { 0, 0 }, { 0, 0 } },
    energy_source = { type = "void" },
    energy_usage_per_tick = "1W",
    darkness_for_all_lamps_on = 0.2,
    darkness_for_all_lamps_off = 0.1,
    light = {
      intensity = 0.8,
      size = 12,
      shift = { 0.0, 1.75 },
      color = { r = 0.95, g = 0.88, b = 0.85 },
    },
    light_when_colored = {
      intensity = 1,
      size = 6,
      color = { r = 1.0, g = 1.0, b = 1.0 },
    },
    glow_size = 6,
    glow_color_intensity = 0.25,
    picture_off = util.empty_sprite(),
    picture_on = util.empty_sprite(),
  },
  {
    type = "simple-entity-with-owner",
    name = "kr-inactive-shelter-plus",
    localised_name = { "entity-name.kr-shelter-plus" },
    localised_description = { "entity-description.kr-shelter-plus" },
    icon = "__Krastorio2Assets__/icons/entities/shelter.png",
    flags = {},
    hidden = true,
    collision_box = { { -2.75, -2.75 }, { 2.75, 2.75 } },
    selection_box = { { -3, -3 }, { 3, 3.20 } },
    minable = { mining_time = 10, result = "kr-shelter-plus" },
    placeable_by = { item = "kr-shelter-plus", count = 1 },
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    picture = animation,
  },
})
