local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

local function rocket_turret_sheet(inputs)
  return {
    layers = {
      {
        filename = "__Krastorio2Assets__/buildings/rocket-turret/rocket-turret.png",
        width = 440,
        height = 380,
        line_length = inputs.frame_count or 8,
        frame_count = inputs.frame_count or 1,
        axially_symmetrical = false,
        direction_count = 64,
        shift = { 0, -0.7 },
        scale = 0.5,
      },

      {
        flags = { "mask" },
        filename = "__Krastorio2Assets__/buildings/rocket-turret/rocket-turret-mask.png",
        width = 440,
        height = 380,
        line_length = inputs.frame_count or 8,
        frame_count = inputs.frame_count or 1,
        axially_symmetrical = false,
        direction_count = 64,
        shift = { 0, -0.7 },
        apply_runtime_tint = true,
        scale = 0.5,
      },

      {
        filename = "__Krastorio2Assets__/buildings/rocket-turret/rocket-turret-shadow.png",
        width = 440,
        height = 380,
        line_length = inputs.frame_count or 8,
        frame_count = inputs.frame_count or 1,
        axially_symmetrical = false,
        direction_count = 64,
        shift = { 0.9, 0.05 },
        draw_as_shadow = true,
        scale = 0.5,
      },
    },
  }
end

data:extend({
  {
    type = "recipe",
    name = "kr-rocket-turret",
    enabled = false,
    energy_required = 20,
    ingredients = {
      { type = "item", name = "rocket-launcher", amount = 6 },
      { type = "item", name = "kr-steel-beam", amount = 10 },
      { type = "item", name = "kr-rare-metals", amount = 20 },
      { type = "item", name = "processing-unit", amount = 20 },
      { type = "item", name = "low-density-structure", amount = 10 },
    },
    results = { { type = "item", name = "kr-rocket-turret", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-rocket-turret",
    icon = "__Krastorio2Assets__/icons/entities/rocket-turret.png",
    subgroup = "kr-rocket-turret",
    order = "a02[rocket-turret]",
    place_result = "kr-rocket-turret",
    stack_size = 50,
  },
  {
    type = "ammo-turret",
    name = "kr-rocket-turret",
    icon = "__Krastorio2Assets__/icons/entities/rocket-turret.png",
    flags = { "placeable-player", "player-creation", "building-direction-8-way" },
    minable = { mining_time = 1, result = "kr-rocket-turret" },
    collision_box = { { -1.75, -1.75 }, { 1.75, 1.75 } },
    selection_box = { { -2, -2 }, { 2, 2 } },
    inventory_size = 1,
    automated_ammo_count = 10,
    rotation_speed = 0.002,
    shoot_in_prepare_state = false,
    turret_base_has_direction = true,
    call_for_help_radius = 90,
    attack_parameters = {
      type = "projectile",
      ammo_category = "kr-turret-missile",
      cooldown = 120,
      turn_range = 1 / 7,
      projectile_creation_distance = 3.35,
      projectile_center = { 0, 0.1 },
      range = 80,
      min_range = 35,
      rotate_penalty = 20,
      health_penalty = -100,
      sound = {
        {
          filename = "__Krastorio2Assets__/sounds/weapons/rocket-launch.ogg",
          volume = 0.8,
        },
      },
    },
    max_health = 1000,
    corpse = "kr-turret-remnant",
    damaged_trigger_effect = hit_effects.entity(),
    dying_explosion = "big-explosion",
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    folded_animation = rocket_turret_sheet({ direction_count = 8, line_length = 1 }),
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    graphics_set = {
      base_visualisation = {
        animation = {
          layers = {
            {
              filename = "__Krastorio2Assets__/buildings/turret-common/turret-base.png",
              priority = "high",
              width = 440,
              height = 380,
              axially_symmetrical = false,
              direction_count = 1,
              frame_count = 1,
              shift = { 0, -0.8 },
              scale = 0.5,
            },
            {
              filename = "__Krastorio2Assets__/buildings/turret-common/turret-base-mask.png",
              flags = { "mask", "low-object" },
              line_length = 1,
              width = 440,
              height = 380,
              axially_symmetrical = false,
              direction_count = 1,
              frame_count = 1,
              shift = { 0, -0.8 },
              apply_runtime_tint = true,
              scale = 0.5,
            },
            {
              filename = "__Krastorio2Assets__/buildings/turret-common/turret-base-shadow.png",
              line_length = 1,
              width = 440,
              height = 380,
              axially_symmetrical = false,
              draw_as_shadow = true,
              direction_count = 1,
              frame_count = 1,
              shift = { 0, -0.8 },
              scale = 0.5,
            },
          },
        },
      },
      water_reflection = {
        pictures = {
          filename = "__Krastorio2Assets__/buildings/turret-common/turret-reflection.png",
          priority = "extra-high",
          width = 50,
          height = 50,
          shift = util.by_pixel(0, 40),
          variation_count = 1,
          scale = 5,
        },
        rotate = false,
        orientation_to_variation = false,
      },
    },
    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions.create_vector(
      universal_connector_template,
      {
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
        { variation = 7, main_offset = util.by_pixel_hr(-61, 61), shadow_offset = util.by_pixel_hr(-61, 61), show_shadow = false },
      }
    )
  },
})
