local hit_effects = require("__base__.prototypes.entity.hit-effects")
local pipe_pictures = require("prototypes.buildings.advanced-furnace-pipe-pictures")
local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-advanced-furnace",
    energy_required = 30,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-imersium-beam", amount = 20 },
      { type = "item", name = "kr-steel-beam", amount = 80 },
      { type = "item", name = "kr-rare-metals", amount = 80 },
      { type = "item", name = "copper-plate", amount = 60 },
      { type = "item", name = "kr-electronic-components", amount = 20 },
      { type = "item", name = "kr-energy-control-unit", amount = 10 },
    },
    results = { { type = "item", name = "kr-advanced-furnace", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-advanced-furnace",
    icon = "__Krastorio2Assets__/icons/entities/advanced-furnace.png",
    subgroup = "smelting-machine",
    order = "c[electric-furnace]-f[advanced-furnace]",
    place_result = "kr-advanced-furnace",
    stack_size = 50,
  },
  {
    type = "assembling-machine",
    name = "kr-advanced-furnace",
    icon = "__Krastorio2Assets__/icons/entities/advanced-furnace.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 1, result = "kr-advanced-furnace" },
    max_health = 2000,
    corpse = "kr-big-random-pipes-remnant",
    dying_explosion = "big-explosion",
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire",     percent = 95 },
      { type = "impact",   percent = 80 },
    },
    collision_box = { { -3.25, -3.25 }, { 3.25, 3.25 } },
    selection_box = { { -3.5, -3.5 }, { 3.5, 3.5 } },
    damaged_trigger_effect = hit_effects.entity(),
    fluid_boxes = {
      {
        production_type = "input",
        pipe_picture = pipe_pictures.a,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { -1, -3 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "input",
        pipe_picture = pipe_pictures.b,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { 1, -3 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "input",
        pipe_picture = pipe_pictures.b,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.west, position = { -3, -1 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "input",
        pipe_picture = pipe_pictures.a,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.east, position = { 3, -1 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "output",
        pipe_picture = pipe_pictures.b,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { -1, 3 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "output",
        pipe_picture = pipe_pictures.a,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { 1, 3 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "output",
        pipe_picture = pipe_pictures.a,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.west, position = { -3, 1 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "output",
        pipe_picture = pipe_pictures.b,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.east, position = { 3, 1 } } },
        secondary_draw_orders = { north = -1 },
      },
    },
    fluid_boxes_off_when_no_fluid_recipe = true,
    crafting_categories = { "smelting", "kr-advanced-smelting" },
    crafting_speed = 12,
    ingredient_count = 6,
    module_slots = 4,
    allowed_effects = { "consumption", "speed", "productivity", "pollution" },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 6 },
    },
    energy_usage = "2MW",
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = {
        filename = "__Krastorio2Assets__/sounds/buildings/advanced-furnace.ogg",
        volume = 0.50,
        aggregation = {
          max_count = 2,
          remove = false,
          count_already_playing = true,
        },
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg" },
    },
    graphics_set = {
      animation = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace.png",
            priority = "high",
            width = 480,
            height = 480,
            shift = { 0, -0.1 },
            frame_count = 1,
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace-sh.png",
            priority = "high",
            width = 165,
            height = 480,
            shift = { 3.1, -0.1 },
            frame_count = 1,
            draw_as_shadow = true,
            scale = 0.5,
          },
        },
      },
      working_visualisations = {
        {
          constant_speed = true,
          animation = {
            filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace-anim-light.png",
            priority = "high",
            width = 480,
            height = 480,
            shift = { 0, -0.1 },
            frame_count = 28,
            line_length = 4,
            animation_speed = 0.8,
            draw_as_light = true,
            scale = 0.5,
          },
        },
        {
          constant_speed = true,
          animation = {
            filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace-anim-glow.png",
            priority = "high",
            width = 480,
            height = 480,
            shift = { 0, -0.1 },
            frame_count = 28,
            line_length = 4,
            animation_speed = 0.8,
            draw_as_glow = true,
            fadeout = true,
            blend_mode = "additive",
            scale = 0.5,
          },
        },
        {
          constant_speed = true,
          animation = {
            filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace-anim.png",
            priority = "high",
            width = 480,
            height = 480,
            shift = { 0, -0.1 },
            frame_count = 28,
            line_length = 4,
            animation_speed = 0.8,
            scale = 0.5,
          },
        },
        {
          constant_speed = true,
          light = {
            intensity = 0.65,
            size = 4,
            shift = { 1.29, 2 },
            color = { r = 1, g = 0.35, b = 0.2 },
          },
        },
      },
      water_reflection = {
        pictures = {
          filename = "__Krastorio2Assets__/buildings/advanced-furnace/advanced-furnace-reflection.png",
          priority = "extra-high",
          width = 80,
          height = 60,
          shift = util.by_pixel(0, 40),
          variation_count = 1,
          scale = 5,
        },
        rotate = false,
        orientation_to_variation = false,
      },
    },
    icon_draw_specification = { scale = 2, shift = { 0, -0.3 } },
    icons_positioning = { { inventory_index = defines.inventory.assembling_machine_modules, shift = { 0, 1.25 } } },

    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions.create_vector(
      universal_connector_template, 
      {
        { variation = 27, main_offset = util.by_pixel(93, 82), shadow_offset = util.by_pixel(93, 77), show_shadow = false },
        { variation = 27, main_offset = util.by_pixel(93, 82), shadow_offset = util.by_pixel(93, 77), show_shadow = false },
        { variation = 27, main_offset = util.by_pixel(93, 82), shadow_offset = util.by_pixel(93, 77), show_shadow = false },
        { variation = 27, main_offset = util.by_pixel(93, 82), shadow_offset = util.by_pixel(93, 77), show_shadow = false }
      }
    )
  },
})
