local resource_autoplace = require("__core__.lualib.resource-autoplace")

data:extend({
  {
    type = "resource",
    name = "kr-mineral-water",
    icon = "__Krastorio2Assets__/icons/resources/mineral-water.png",
    flags = { "placeable-neutral" },
    category = "basic-fluid",
    subgroup = "mineable-fluids",
    order = "a-b-a",
    infinite = false,
    map_grid = false,
    highlight = true,
    minimum = 20000,
    normal = 75000,
    infinite_depletion_amount = 10,
    resource_patch_search_radius = 12,
    tree_removal_probability = 1,
    tree_removal_max_distance = 32 * 32,
    minable = {
      mining_time = 1,
      results = {
        {
          type = "fluid",
          name = "kr-mineral-water",
          amount_min = 20,
          amount_max = 20,
          probability = 1,
        },
      },
    },
    collision_box = { { -1.4, -1.4 }, { 1.4, 1.4 } },
    selection_box = { { -1, -1 }, { 1, 1 } },
    autoplace = resource_autoplace.resource_autoplace_settings({
      name = "kr-mineral-water",
      order = "c",
      base_density = 2,
      base_spots_per_km2 = 0.5,
      random_probability = 1 / 50,
      random_spot_size_minimum = 1,
      random_spot_size_maximum = 1,
      additional_richness = 50000,
      has_starting_area_placement = false,
      regular_rq_factor_multiplier = 1,
    }),
    stage_counts = { 0 },
    stages = {
      sheet = {
        filename = "__Krastorio2Assets__/resources/mineral-water.png",
        priority = "extra-high",
        width = 128,
        height = 128,
        frame_count = 8,
        variation_count = 1,
      },
    },
    map_color = { r = 0.35, g = 0.5, b = 0.75 },
  },
  {
    type = "autoplace-control",
    name = "kr-mineral-water",
    localised_name = { "", "[entity=kr-mineral-water] ", { "autoplace-control-names.kr-mineral-water" } },
    order = "k-b",
    richness = true,
    category = "resource",
  },
})
