data:extend({
  {
    type = "recipe",
    name = "kr-advanced-fuel",
    icon = "__Krastorio2Assets__/icons/items/advanced-fuel.png",
    subgroup = "intermediate-product",
    order = "o4[bio-fuel]",
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 10,
    ingredients = {
      { type = "item", name = "kr-fuel", amount = 10 },
      { type = "item", name = "kr-imersite-powder", amount = 6 },
    },
    results = {
      { type = "item", name = "kr-advanced-fuel", amount = 10 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.30, g = 0.53, b = 0.20, a = 0.000 },
      secondary = { r = 0.30, g = 0.53, b = 0.20, a = 0.250 },
      tertiary = { r = 0.454, g = 0.517, b = 0.529, a = 0.500 },
      quaternary = { r = 0.662, g = 0.807, b = 0.839, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-biofuel",
    icon = "__Krastorio2Assets__/icons/items/bio-fuel.png",
    subgroup = "intermediate-product",
    order = "o3[bio-fuel]",
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 10,
    ingredients = {
      { type = "item", name = "kr-fuel", amount = 6 },
      { type = "fluid", name = "kr-biomethanol", amount = 50 },
    },
    results = {
      { type = "item", name = "kr-biofuel", amount = 10 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.30, g = 0.53, b = 0.20, a = 0.000 },
      secondary = { r = 0.30, g = 0.53, b = 0.20, a = 0.250 },
      tertiary = { r = 0.454, g = 0.517, b = 0.529, a = 0.500 },
      quaternary = { r = 0.662, g = 0.807, b = 0.839, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-biomethanol",
    icon = "__Krastorio2Assets__/icons/fluids/biomethanol.png",
    subgroup = "fluid-recipes",
    order = "y08[biomethanol]",
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 20,
    ingredients = {
      { type = "item", name = "wood", amount = 5 },
      { type = "fluid", name = "kr-oxygen", amount = 60 },
      { type = "fluid", name = "steam", amount = 120 },
    },
    results = {
      { type = "fluid", name = "kr-biomethanol", amount = 120 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.25, g = 0.53, b = 0.15, a = 0.750 },
      secondary = { r = 0.27, g = 0.53, b = 0.12, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-fuel-from-light-oil",
    subgroup = "intermediate-product",
    order = "o1[fuel-from-light-oil]",
    icons = {
      { icon = "__Krastorio2Assets__/icons/items/fuel.png" },
      {
        icon = "__base__/graphics/icons/fluid/light-oil.png",
        scale = 0.26,
        shift = { 8, -8 },
      },
    },
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 10,
    ingredients = {
      { type = "fluid", name = "light-oil", amount = 60 },
    },
    results = {
      { type = "item", name = "kr-fuel", amount = 10 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.662, g = 0.807, b = 0.839, a = 0.000 },
      secondary = { r = 0.541, g = 0.647, b = 0.670, a = 0.250 },
      tertiary = { r = 0.454, g = 0.517, b = 0.529, a = 0.500 },
      quaternary = { r = 0.662, g = 0.807, b = 0.839, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-fuel-from-solid-fuel",
    icons = {
      { icon = "__Krastorio2Assets__/icons/items/fuel.png" },
      {
        icon = data.raw.item["solid-fuel"].icon,
        icon_size = data.raw.item["solid-fuel"].icon_size or 64,
        scale = 0.26,
        shift = { 8, -8 },
      },
    },
    subgroup = "intermediate-product",
    order = "o2[fuel-from-solid-fuel]",
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 10,
    ingredients = {
      { type = "item", name = "solid-fuel", amount = 6 },
      { type = "fluid", name = "kr-hydrogen", amount = 50 },
    },
    results = {
      { type = "item", name = "kr-fuel", amount = 10 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.662, g = 0.807, b = 0.839, a = 0.000 },
      secondary = { r = 0.541, g = 0.647, b = 0.670, a = 0.250 },
      tertiary = { r = 0.454, g = 0.517, b = 0.529, a = 0.500 },
      quaternary = { r = 0.662, g = 0.807, b = 0.839, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-rocket-fuel-with-ammonia",
    icons = {
      { icon = "__Krastorio2Assets__/icons/recipes/rocket-fuel.png" },
      { icon = "__Krastorio2Assets__/icons/fluids/ammonia.png", scale = 0.26, shift = { 8, -8 } },
    },
    enabled = false,
    energy_required = 16,
    category = "kr-fuel-refinery",
    ingredients = {
      { type = "item", name = "iron-plate", amount = 1 },
      { type = "fluid", name = "kr-ammonia", amount = 50 },
      { type = "fluid", name = "kr-oxygen", amount = 50 },
    },
    results = {
      { type = "item", name = "rocket-fuel", amount = 1 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    crafting_machine_tint = {
      primary = { r = 0.261, g = 0.200, b = 0.650, a = 0.100 },
      secondary = { r = 0.211, g = 0.447, b = 0.670, a = 0.250 },
      tertiary = { r = 0.204, g = 0.417, b = 0.529, a = 0.500 },
      quaternary = { r = 0.312, g = 0.407, b = 0.739, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-rocket-fuel-with-hydrogen-chloride",
    icons = {
      { icon = "__Krastorio2Assets__/icons/recipes/rocket-fuel.png" },
      {
        icon = "__Krastorio2Assets__/icons/fluids/hydrogen-chloride.png",
        scale = 0.26,
        shift = { 8, -8 },
      },
    },
    enabled = false,
    category = "kr-fuel-refinery",
    energy_required = 16,
    ingredients = {
      { type = "item", name = "iron-plate", amount = 1 },
      { type = "fluid", name = "kr-hydrogen-chloride", amount = 50 },
      { type = "fluid", name = "kr-oxygen", amount = 50 },
    },
    results = {
      { type = "item", name = "rocket-fuel", amount = 1 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    crafting_machine_tint = {
      primary = { r = 0.421, g = 0.720, b = 0.350, a = 0.100 },
      secondary = { r = 0.541, g = 0.797, b = 0.370, a = 0.250 },
      tertiary = { r = 0.354, g = 0.527, b = 0.229, a = 0.500 },
      quaternary = { r = 0.362, g = 0.617, b = 0.439, a = 0.900 },
    },
  },
})
