data:extend({
  {
    type = "recipe",
    name = "kr-ammonia",
    icon = "__Krastorio2Assets__/icons/fluids/ammonia.png",
    subgroup = "fluid-recipes",
    order = "y03[ammonia]",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-hydrogen", amount = 50 },
      { type = "fluid", name = "kr-nitrogen", amount = 50 },
    },
    results = {
      { type = "fluid", name = "kr-ammonia", amount = 50 },
    },
    always_show_made_in = true,
    always_show_products = true,
    allow_productivity = true,
    crafting_machine_tint = {
      primary = { r = 0.106, g = 0.000, b = 0.50, a = 0.250 },
      secondary = { r = 0.200, g = 0.000, b = 0.690, a = 0.127 },
      tertiary = { r = 0.210, g = 0.000, b = 0.75, a = 0.350 },
      quaternary = { r = 0.106, g = 0.000, b = 0.50, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-dt-fuel-cell",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-heavy-water", amount = 10 },
      { type = "item", name = "kr-tritium", amount = 1 },
      { type = "item", name = "kr-empty-dt-fuel-cell", amount = 1 },
    },
    results = { { type = "item", name = "kr-dt-fuel-cell", amount = 1 } },
    always_show_made_in = true,
    allow_productivity = false,
    crafting_machine_tint = {
      primary = { r = 0.800, g = 0.776, b = 0.313, a = 0.000 },
      secondary = { r = 0.200, g = 0.680, b = 0.300, a = 0.350 },
      tertiary = { r = 0.430, g = 0.305, b = 0.2, a = 0.750 },
      quaternary = { r = 0.800, g = 0.776, b = 0.313, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-enriched-copper",
    icon = "__Krastorio2Assets__/icons/items/enriched-copper.png",
    enabled = false,
    category = "chemistry",
    energy_required = 3,
    ingredients = {
      { type = "fluid", name = "sulfuric-acid", amount = 3 },
      { type = "fluid", name = "water", amount = 25 },
      { type = "item", name = "copper-ore", amount = 9 },
    },
    results = {
      { type = "item", name = "kr-enriched-copper", amount = 6 },
      { type = "fluid", name = "kr-dirty-water", amount = 25, ignored_by_productivity = 25 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.970, g = 0.501, b = 0.000, a = 0.000 },
      secondary = { r = 0.200, g = 0.680, b = 0.300, a = 0.357 },
      tertiary = { r = 0.430, g = 0.305, b = 0.2, a = 0.000 },
      quaternary = { r = 0.970, g = 0.501, b = 0.000, a = 0.900 },
    },
    subgroup = "raw-material",
    order = "e02[enriched-copper]",
  },
  {
    type = "recipe",
    name = "kr-enriched-iron",
    icon = "__Krastorio2Assets__/icons/items/enriched-iron.png",
    subgroup = "raw-material",
    order = "e01[enriched-iron]",
    enabled = false,
    category = "chemistry",
    energy_required = 3,
    ingredients = {
      { type = "fluid", name = "sulfuric-acid", amount = 3 },
      { type = "fluid", name = "water", amount = 25 },
      { type = "item", name = "iron-ore", amount = 9 },
    },
    results = {
      { type = "item", name = "kr-enriched-iron", amount = 6 },
      { type = "fluid", name = "kr-dirty-water", amount = 25, ignored_by_productivity = 25 },
    },
    always_show_made_in = true,
    always_show_products = true,
    allow_productivity = true,
    crafting_machine_tint = {
      primary = { r = 0.25, g = 0.50, b = 0.65, a = 0.200 },
      secondary = { r = 0.50, g = 0.70, b = 0.90, a = 0.357 },
      tertiary = { r = 0.10, g = 0.25, b = 0.50, a = 0.100 },
      quaternary = { r = 0.25, g = 0.50, b = 0.65, a = 0.850 },
    },
  },
  {
    type = "recipe",
    name = "kr-enriched-rare-metals",
    icon = "__Krastorio2Assets__/icons/items/enriched-rare-metals.png",
    subgroup = "raw-material",
    order = "e03[enriched-rare-metals]",
    enabled = false,
    category = "chemistry",
    energy_required = 3,
    ingredients = {
      { type = "fluid", name = "kr-hydrogen-chloride", amount = 10 },
      { type = "fluid", name = "water", amount = 25 },
      { type = "item", name = "kr-rare-metal-ore", amount = 9 },
    },
    results = {
      { type = "item", name = "kr-enriched-rare-metals", amount = 6 },
      { type = "fluid", name = "kr-dirty-water", amount = 25, ignored_by_productivity = 25 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.721, g = 0.525, b = 0.043, a = 0.000 },
      secondary = { r = 0.200, g = 0.680, b = 0.300, a = 0.357 },
      tertiary = { r = 0.690, g = 0.768, b = 0.870, a = 0.000 },
      quaternary = { r = 0.0, g = 0.980, b = 0.603, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-fertilizer",
    enabled = false,
    category = "chemistry",
    energy_required = 10,
    ingredients = {
      { type = "fluid", name = "kr-nitric-acid", amount = 10 },
      { type = "item", name = "kr-biomass", amount = 2 },
    },
    results = {
      { type = "item", name = "kr-fertilizer", amount = 10 },
    },
    allow_productivity = true,
    crafting_machine_tint = {
      primary = { r = 0.160, g = 0.678, b = 0, 274, a = 1.000 },
      secondary = { r = 0.121, g = 0.517, b = 0.235, a = 0.900 },
      tertiary = { r = 0.054, g = 0.239, b = 0.086, a = 0.500 },
      quaternary = { r = 0.054, g = 0.239, b = 0.086, a = 0.300 },
    },
  },
  {
    type = "recipe",
    name = "kr-hydrogen-chloride",
    icon = "__Krastorio2Assets__/icons/fluids/hydrogen-chloride.png",
    subgroup = "fluid-recipes",
    order = "y05[hydrogen-chloride]",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-chlorine", amount = 50 },
      { type = "fluid", name = "kr-hydrogen", amount = 50 },
    },
    results = {
      { type = "fluid", name = "kr-hydrogen-chloride", amount = 50 },
    },
    always_show_made_in = true,
    always_show_products = true,
    allow_productivity = true,
    crafting_machine_tint = {
      primary = { r = 0.835, g = 0.901, b = 0.862, a = 0.250 },
      secondary = { r = 0.698, g = 0.839, b = 0.756, a = 0.127 },
      tertiary = { r = 0.321, g = 0.890, b = 0.443, a = 0.250 }, -- #52e371
      quaternary = { r = 0.835, g = 0.901, b = 0.862, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-imersite-crystal",
    category = "chemistry",
    subgroup = "intermediate-product",
    order = "o6[imersite-crystal]",
    icon = "__Krastorio2Assets__/icons/items/imersite-crystal.png",
    enabled = false,
    energy_required = 30,
    ingredients = {
      { type = "item", name = "kr-imersite-powder", amount = 6 },
      { type = "fluid", name = "kr-nitric-acid", amount = 10 },
      { type = "fluid", name = "sulfuric-acid", amount = 10 },
    },
    results = { { type = "item", name = "kr-imersite-crystal", amount = 1 } },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.882, g = 0.337, b = 0.890, a = 0.200 },
      secondary = { r = 0.90, g = 0.30, b = 0.25, a = 0.357 },
      tertiary = { r = 0.623, g = 0.270, b = 0.631, a = 0.100 },
      quaternary = { r = 0.882, g = 0.337, b = 0.890, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-water",
    localised_name = { "fluid-name.water" },
    icon = "__Krastorio2Assets__/icons/recipes/water.png",
    icon_size = 128,
    subgroup = "fluid-recipes",
    order = "y03[water]",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-oxygen", amount = 20 },
      { type = "fluid", name = "kr-hydrogen", amount = 30 },
    },
    results = {
      { type = "fluid", name = "water", amount = 50 },
    },
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.39, g = 0.822, b = 0.968, a = 1.000 },
      secondary = { r = 0.391, g = 0.720, b = 1.000, a = 0.900 },
      tertiary = { r = 1.000, g = 1.000, b = 1.000, a = 0.500 },
      quaternary = { r = 1.000, g = 1.000, b = 1.000, a = 0.300 },
    },
  },
  {
    type = "recipe",
    name = "kr-lithium-chloride",
    subgroup = "raw-material",
    order = "h1[lithium-chloride]",
    icon = "__Krastorio2Assets__/icons/items/lithium-chloride.png",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-mineral-water", amount = 50 },
      { type = "fluid", name = "kr-hydrogen-chloride", amount = 10 },
    },
    results = {
      { type = "item", name = "kr-lithium-chloride", amount = 5 },
    },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.662, g = 0.807, b = 0.839, a = 0.000 },
      secondary = { r = 0.541, g = 0.647, b = 0.670, a = 0.250 },
      tertiary = { r = 0.454, g = 0.517, b = 0.529, a = 0.500 },
      quaternary = { r = 0.662, g = 0.807, b = 0.839, a = 0.900 },
    },
  },
  {
    type = "recipe",
    name = "kr-lithium-sulfur-battery",
    enabled = false,
    category = "chemistry",
    energy_required = 4,
    ingredients = {
      { type = "fluid", name = "sulfuric-acid", amount = 10 },
      { type = "item", name = "kr-lithium", amount = 1 },
      { type = "item", name = "copper-plate", amount = 1 },
    },
    results = { { type = "item", name = "kr-lithium-sulfur-battery", amount = 1 } },
    allow_productivity = true,
    always_show_made_in = true,
    always_show_products = true,
    crafting_machine_tint = {
      primary = { r = 0.35, g = 0.392, b = 0.328, a = 0.900 },
      secondary = { r = 0.831, g = 0.760, b = 0.422, a = 0.800 },
      tertiary = { r = 0.408, g = 0.568, b = 0.533, a = 0.700 },
      quaternary = { r = 0.939, g = 0.863, b = 1.191, a = 0.600 },
    },
  },
  {
    type = "recipe",
    name = "kr-nitric-acid",
    icon = "__Krastorio2Assets__/icons/fluids/nitric-acid.png",
    subgroup = "fluid-recipes",
    order = "y04[nitric-acid]",
    enabled = false,
    category = "chemistry",
    energy_required = 5,
    ingredients = {
      { type = "fluid", name = "kr-ammonia", amount = 50 },
      { type = "fluid", name = "kr-mineral-water", amount = 25 },
      { type = "item", name = "kr-rare-metals", amount = 1 },
    },
    results = {
      { type = "fluid", name = "kr-nitric-acid", amount = 50 },
    },
    always_show_made_in = true,
    always_show_products = true,
    allow_productivity = true,
    crafting_machine_tint = {
      primary = { r = 0.800, g = 0.000, b = 0.100, a = 0.200 },
      secondary = { r = 0.500, g = 0.100, b = 0.300, a = 0.357 },
      tertiary = { r = 0.430, g = 0.000, b = 0.450, a = 0.200 },
      quaternary = { r = 0.800, g = 0.000, b = 0.100, a = 0.900 },
    },
  },
})
