// Tworzenie elementu canvas
var canvas = document.createElement("canvas");
canvas.width = 800;
canvas.height = 600;
document.body.appendChild(canvas);
var ctx = canvas.getContext("2d");

// Pozycja początkowa samochodu gracza
var playerCarX = canvas.width / 2;
var playerCarY = canvas.height / 2;
var playerCarWidth = 20;
var playerCarHeight = 35;
var playerCarAngle = 0; // Kąt obrócenia samochodu gracza

// Pozycja początkowa samochodu komputera
var computerCarX = canvas.width / 2;
var computerCarY = canvas.height / 2;
var computerCarWidth = 20;
var computerCarHeight = 35;
var computerCarAngle = 0; // Kąt obrócenia samochodu komputera

var rotationSpeed = 0.1; // Prędkość obrotu samochodów
var movementSpeed = 2; // Prędkość poruszania się samochodu komputera

// Zmienne do punktacji
var playerScore = 0;
var computerScore = 0;
var yellowSquares = []; // Tablica przechowująca żółte kwadraty

// Dodanie losowych żółtych kwadratów
function addYellowSquare() {
  var squareSize = 10;
  var squareX = Math.random() * (canvas.width - squareSize);
  var squareY = Math.random() * (canvas.height - squareSize);

  yellowSquares.push({
    x: squareX,
    y: squareY,
    size: squareSize
  });
}

// Aktualizacja pozycji samochodów
function updateCarPositions() {
  // Aktualizacja pozycji samochodu gracza
  if (keys.ArrowUp) {
    // Przesuwanie samochodu gracza do przodu
    playerCarX += Math.sin(playerCarAngle) * 5;
    playerCarY -= Math.cos(playerCarAngle) * 5;
  }
  if (keys.ArrowDown) {
    // Przesuwanie samochodu gracza do tyłu
    playerCarX -= Math.sin(playerCarAngle) * 5;
    playerCarY += Math.cos(playerCarAngle) * 5;
  }
  if (keys.ArrowLeft) {
    // Obracanie samochodu gracza w lewo
    playerCarAngle -= rotationSpeed;
  }
  if (keys.ArrowRight) {
    // Obracanie samochodu gracza w prawo
    playerCarAngle += rotationSpeed;
  }

  // Aktualizacja pozycji samochodu komputera
  // Samochód komputera obraca się w kierunku najbliższego żółtego kwadratu
  var nearestSquare = getNearestSquare();
  if (nearestSquare) {
    var angleToSquare = Math.atan2(
      nearestSquare.y - computerCarY,
      nearestSquare.x - computerCarX
    );
    computerCarAngle = angleToSquare;

    // Przesuwanie samochodu komputera do przodu w kierunku najbliższego kwadratu
    computerCarX += Math.sin(computerCarAngle) * movementSpeed;
    computerCarY -= Math.cos(computerCarAngle) * movementSpeed;
  }

  // Sprawdzenie styczności samochodów z żółtymi kwadratami
  for (var i = 0; i < yellowSquares.length; i++) {
    var square = yellowSquares[i];
    if (
      playerCarX < square.x + square.size &&
      playerCarX + playerCarWidth > square.x &&
      playerCarY < square.y + square.size &&
      playerCarY + playerCarHeight > square.y
    ) {
      // Styczność samochodu gracza z żółtym kwadratem
      yellowSquares.splice(i, 1); // Usunięcie kwadratu z tablicy
      playerScore += 10; // Zwiększenie wyniku gracza o 10 punktów
    }
    if (
      computerCarX < square.x + square.size &&
      computerCarX + computerCarWidth > square.x &&
      computerCarY < square.y + square.size &&
      computerCarY + computerCarHeight > square.y
    ) {
      // Styczność samochodu komputera z żółtym kwadratem
      yellowSquares.splice(i, 1); // Usunięcie kwadratu z tablicy
      computerScore += 10; // Zwiększenie wyniku komputera o 10 punktów
    }
  }

  // Rysowanie samochodów na nowych pozycjach i pod odpowiednim kątem
  ctx.fillStyle = "lightgray";
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  drawCar(playerCarX, playerCarY, playerCarWidth, playerCarHeight, playerCarAngle, "blue"); // Rysowanie samochodu gracza
  drawCar(computerCarX, computerCarY, computerCarWidth, computerCarHeight, computerCarAngle, "red"); // Rysowanie samochodu komputera

  // Rysowanie żółtych kwadratów
  ctx.fillStyle = "yellow";
  for (var i = 0; i < yellowSquares.length; i++) {
    var square = yellowSquares[i];
    ctx.fillRect(square.x, square.y, square.size, square.size);
  }

  // Rysowanie wyników
  ctx.fillStyle = "black";
  ctx.font = "24px Arial";
  ctx.fillText("Player Score: " + playerScore, 10, 30);
  ctx.fillText("AI Score: " + computerScore, 10, 60);

  // Dodawanie nowych żółtych kwadratów co 1 sekundę
  if (Math.random() < 0.01) {
    addYellowSquare();
  }

  // Ponowne wywołanie funkcji aktualizującej
  requestAnimationFrame(updateCarPositions);
}

// Funkcja pomocnicza do rysowania samochodu
function drawCar(x, y, width, height, angle, color) {
  ctx.save(); // Zapisanie obecnego stanu rysowania
  ctx.translate(x, y); // Przesunięcie do pozycji samochodu
  ctx.rotate(angle); // Obrót samochodu
  ctx.fillStyle = color;
  var image = new Image();
  image.src = "car.png";
  ctx.drawImage(image, -width / 2, -height / 2, width, height); // Rysowanie kwadratu wokół środka samochodu
  ctx.restore(); // Przywrócenie poprzedniego stanu rysowania
}

// Funkcja pomocnicza do obliczania najbliższego żółtego kwadratu
function getNearestSquare() {
  var nearestSquare = null;
  var minDistance = Infinity;
  for (var i = 0; i < yellowSquares.length; i++) {
    var square = yellowSquares[i];
    var distance = Math.sqrt(
      Math.pow(square.x - computerCarX, 2) + Math.pow(square.y - computerCarY, 2)
    );
    if (distance < minDistance) {
      minDistance = distance;
      nearestSquare = square;
    }
  }
  return nearestSquare;
}

// Obsługa naciśnięcia klawiszy
var keys = {};
document.addEventListener("keydown", function (e) {
  keys[e.code] = true;
});
document.addEventListener("keyup", function (e) {
  keys[e.code] = false;
});

// Wywołanie funkcji aktualizującej po załadowaniu strony
window.onload = function () {
  addYellowSquare(); // Dodanie pierwszego żółtego kwadratu
  updateCarPositions();
};
