#define bezier_init
global.bezgrid = ds_grid_create(256,8)           //uzyj tylko raz w czasie dzialania gry, aby zapobiec zasmiecaniu pamieci

#define bezier_new
/*tworzy nowa krzywa beziera o nastepujacych argumentach:
-index - ID krzywej, referujesz do niej w innych skryptach
-x1,y1 - pierwszy koniec krzywej
-x2,y2 - pierwszy punkt kontrolny (aby lepiej poznac ich dzialanie, wejdz na strone http://pl.wikipedia.org/wiki/Krzywa_Bziera lub wlacz przyklad bezier_diagram.gm81)
-x3,y3 - drugi punkt kontrolny
-x4,y4 - drugi koniec krzywej
*/
ds_grid_set(global.bezgrid,argument0,0,argument1)
ds_grid_set(global.bezgrid,argument0,1,argument2)
ds_grid_set(global.bezgrid,argument0,2,argument3)
ds_grid_set(global.bezgrid,argument0,3,argument4)
ds_grid_set(global.bezgrid,argument0,4,argument5)
ds_grid_set(global.bezgrid,argument0,5,argument6)
ds_grid_set(global.bezgrid,argument0,6,argument7)
ds_grid_set(global.bezgrid,argument0,7,argument8)

#define bezier_set
/*zmienia wartosc jednego z parametrow krzywej, argumenty:
-index - ID krzywej
-parameter - wybrany parametr krzywej:
0 - x1; 1- y1; 2 - x2; 3 - y2; 4 - x3; 5 - y3; 6 - x4; 7 - y4
-value - zadana wartosc parametru
*/
ds_grid_set(global.bezgrid,argument0,argument1,argument2)

#define bezier_get
/*Zwraca wartosc wybranego parametru krzywej, argumenty:
-index - ID krzywej
-parameter - wybrany parametr krzywej:
0 - x1; 1- y1; 2 - x2; 3 - y2; 4 - x3; 5 - y3; 6 - x4; 7 - y4
*/
return ds_grid_get(global.bezgrid,argument0,argument1)

#define bezier_x
/*Zwraca wartosc x w wybranym miejscu krzywej Beziera, argumenty:
-index - ID krzywej
-value - wybrany punkt krzywej Beziera, ktorego wartosc x chcemy znac, przyjmuje wartosc od 0 do 1
 (po wiecej informacji wejdz na strone http://pl.wikipedia.org/wiki/Krzywa_Bziera lub wlacz przyklad bezier_diagram.gm81)
*/
var x1,x2,x3,x4,t;
x1 = ds_grid_get(global.bezgrid,argument0,0)
x2 = ds_grid_get(global.bezgrid,argument0,2)
x3 = ds_grid_get(global.bezgrid,argument0,4)
x4 = ds_grid_get(global.bezgrid,argument0,6)
t = argument1
return(x1*power(1-t,3)+3*x2*t*sqr(1-t)+3*x3*sqr(t)*(1-t)+x4*power(t,3))

#define bezier_y
/*Zwraca wartosc y w wybranym miejscu krzywej Beziera, argumenty:
-index - ID krzywej
-value - wybrany punkt krzywej Beziera, ktorego wartosc y chcemy znac, przyjmuje wartosc od 0 do 1
 (po wiecej informacji wejdz na strone http://pl.wikipedia.org/wiki/Krzywa_Bziera lub wlacz przyklad bezier_diagram.gm81)
*/
var y1,y2,y3,y4,t;
y1 = ds_grid_get(global.bezgrid,argument0,1)
y2 = ds_grid_get(global.bezgrid,argument0,3)
y3 = ds_grid_get(global.bezgrid,argument0,5)
y4 = ds_grid_get(global.bezgrid,argument0,7)
t = argument1
return(y1*power(1-t,3)+3*y2*t*sqr(1-t)+3*y3*sqr(t)*(1-t)+y4*power(t,3))

