#define layer_init
global.__dll = argument0;
if(is_real(argument0)) global.__dll="GMDLL.dll";
global.__layerinit = external_define(global.__dll,'Init',dll_cdecl,ty_real,1,ty_real);
global.__layerdll = external_define(global.__dll,'DLLVer',dll_cdecl,ty_string,0);
global.__layerasetr = external_define(global.__dll,'SetArgumentReal',dll_cdecl,ty_real,1,ty_real);
global.__layerasets = external_define(global.__dll,'SetArgumentString',dll_cdecl,ty_real,1,ty_string);
global.__layeraclear = external_define(global.__dll,'ClearArguments',dll_cdecl,ty_real,0);
global.__layerfuncr = external_define(global.__dll,'FuncReal',dll_cdecl,ty_real,2,ty_real,ty_string);
global.__layerfuncs = external_define(global.__dll,'FuncString',dll_cdecl,ty_string,2,ty_real,ty_string);
global.__layerldll = external_define(global.__dll,'LoadDll',dll_cdecl,ty_real,1,ty_string);

global.__layerlast = external_define(global.__dll,'LastError',dll_cdecl,ty_string,0);
global.__layercreate = external_define(global.__dll,'CreateInstance',dll_cdecl,ty_real,2,ty_real,ty_string);

if (external_call(global.__layerdll) != "1.0 BETA")
{
    show_error("LAYER VERSION MISMATCH!",true);
}
if (!external_call(global.__layerinit,1))
{
    show_error("LAYER INIT FAILED!",true);
}






#define layer_loaddll
// argument0: filename
// returns: dll_handle
return external_call(global.__layerldll,argument0);

#define layer_createinstance
//argument0: dll_handle
//argument1: class name
//argument2: argumentcount (max 8!)
//argument3-10: arguments
//returns: instance_handle
var i, r;
external_call(global.__layeraclear);
for (i = 0; i < argument2; i+=1)
{
    if (is_string(argument[i+3]))
    {
        external_call(global.__layerasets,argument[i+3]);
    }
    else
    {
        external_call(global.__layerasetr,argument[i+3]);
    }
}
r = external_call(global.__layercreate,argument0,argument1);
external_call(global.__layeraclear);
return r;

#define layer_function
//argument0: instance_handle
//argument1: function_name
//argument2: returntype (ty_real / ty_string)
//argument3: argumentcount (max 8!)
//argument4-11: arguments

var i, r;
external_call(global.__layeraclear);
for (i = 0; i < argument3; i+=1)
{
    if (is_string(argument[i+4]))
    {
        external_call(global.__layerasets,argument[i+4]);
    }
    else
    {
        external_call(global.__layerasetr,argument[i+4]);
    }
}
if (argument2 == ty_string)
{
    r = external_call(global.__layerfuncs,argument0,argument1);
}
else
{
    r = external_call(global.__layerfuncr,argument0,argument1);
}
external_call(global.__layeraclear);
return r;

    

#define ehttp_init
//argument0 (optional) - path to EasyHTTP.dll (with filename)
//argument1 (optional) - path to GMDLL.dll (with filename) 
var layername;
var name;
if(is_real(argument0)) name="EasyHTTP.dll"; else name=argument0;
if(is_real(argument1)) layername="GMDLL.dll"; else layername=argument1;
layer_init(layername);
global.__ehttpdll=layer_loaddll(name);

#define ehttp_new_instance
return layer_createinstance(global.__ehttpdll,"EasyHTTP.EasyHttpRequest",0);

#define ehttp_build_uri
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - host name
//argument2 - path of file
//argument3 - port. default http is 80
//argument4 - user name
//argument5 - password
return layer_function(argument0,"BuildUri",ty_string,5,argument1,argument2,argument3,argument4,argument5);

#define ehttp_add_get_parametr
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - name of parametr
//argument2 - value of parametr
return layer_function(argument0,"AddGetParametr",ty_real,2,argument1,argument2);

#define ehttp_add_post_parametr
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - name of parametr
//argument2 - value of parametr
return layer_function(argument0,"AddPostParametr",ty_real,2,argument1,argument2);

#define ehttp_clear_get_parametrs
//argument0 - instance handle returned from ehttp_new_instance
return layer_function(argument0,"ClearGetParametrs",ty_real);

#define ehttp_clear_post_parametrs
//argument0 - instance handle returned from ehttp_new_instance
return layer_function(argument0,"ClearPostParametrs",ty_real);

#define ehttp_set_user_agent
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - name of user agent. default is EasyHttpRequest DLL Agent
return layer_function(argument0,"SetUserAgent",ty_real,1,argument1);

#define ehttp_set_content_type
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - content type. default is application/x-www-form-urlencoded
return layer_function(argument0,"SetContentType",ty_real,1,argument1);

#define ehttp_send_request_and_get_response
//argument0 - instance handle returned from ehttp_new_instance
//argument1 - uri to request

return layer_function(argument0,"SendRequestAndGetResponse",ty_string,1,argument1);

#define ehttp_free
external_free(global.__dll);

