//AUTHOR: Utermiko

#using <mscorlib.dll>
#include "stdafx.h"
#include <msclr\marshal.h>
#include "CrossoverManager.h"
#include <Windows.h>

#define EXPORT extern "C" __declspec(dllexport)
#define CALLING_CONVENTION __stdcall

using namespace System;
using namespace DotNetSlapCrossover;
using namespace System::Runtime::InteropServices;

////// Other
char* ToCharPtr(Object^ object)
{
	if(object != nullptr) return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(Convert::ToString(object)); else return "ERROR";
}
char* ToCharPtr(String^ string)
{
	if(string != nullptr) return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(string); else return "ERROR";
}
int ToInt(char* value)
{
	return Convert::ToInt32(gcnew String(value));
}

EXPORT int CALLING_CONVENTION LoadDll(char* path)
{
	return CrossoverManager::LoadDll(gcnew String(path));
}
EXPORT int CALLING_CONVENTION CreateObject(int assemblyId, char* namespaceAndClass)
{
	return CrossoverManager::CreateObject(assemblyId,gcnew String(namespaceAndClass));
}
EXPORT int CALLING_CONVENTION RemoveObject(int objectId)
{
	return CrossoverManager::RemoveObject(objectId);
}

EXPORT int CALLING_CONVENTION ClearArguments()
{
	return CrossoverManager::ClearArguments();
}
EXPORT int CALLING_CONVENTION AddStringArgument(char* value)
{
	return CrossoverManager::AddArgument(gcnew String(value));
}
EXPORT int CALLING_CONVENTION AddCharArgument(char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUCharArgument(unsigned char value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddDoubleArgument(double value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddFloatArgument(float value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddIntArgument(int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUIntArgument(unsigned int value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddShortArgument(short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddUShortArgument(unsigned short value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddLongArgument(long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddULongArgument(unsigned long value)
{
	return CrossoverManager::AddArgument(value);
}
EXPORT int CALLING_CONVENTION AddLPVOIDArgument(LPVOID value)
{
	return CrossoverManager::AddArgument(gcnew IntPtr(value));
}

EXPORT char* CALLING_CONVENTION InvokeStringMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	//if(ret != nullptr) return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi((String^)ret); else return "ERROR";
	return ToCharPtr(ret);
}
EXPORT char CALLING_CONVENTION InvokeCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (char)ret; else return -1;
}
EXPORT unsigned char CALLING_CONVENTION InvokeUCharMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned char)ret; else return 0;
}
EXPORT double CALLING_CONVENTION InvokeDoubleMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (double)ret; else return -1;
}
EXPORT float CALLING_CONVENTION InvokeFloatMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (float)ret; else return -1;
}
EXPORT int CALLING_CONVENTION InvokeIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (int)ret; else return -1;
}
EXPORT unsigned int CALLING_CONVENTION InvokeUIntMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned int)ret; else return 0;
}
EXPORT short CALLING_CONVENTION InvokeShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (short)ret; else return -1;
}
EXPORT unsigned short CALLING_CONVENTION InvokeUShortMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned short)ret; else return 0;
}
EXPORT long CALLING_CONVENTION InvokeLongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (long)ret; else return -1;
}
EXPORT unsigned long CALLING_CONVENTION InvokeULongMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return (unsigned long)ret; else return 0;
}
EXPORT LPVOID CALLING_CONVENTION InvokeLPVOIDMethod(int objectId, char* methodName)
{
	Object^ ret = CrossoverManager::InvokeMethod(objectId, gcnew String(methodName));
	if(ret != nullptr) return ((IntPtr^)ret)->ToPointer(); else return ((IntPtr^)IntPtr::Zero)->ToPointer();
}

////// AsCharPtr functions

EXPORT char* CALLING_CONVENTION LoadDllAsCharPtr(char* path)
{
	return ToCharPtr(LoadDll(path));
}
EXPORT char* CALLING_CONVENTION CreateObjectAsCharPtr(char* assemblyId, char* namespaceAndClass)
{
	return ToCharPtr(CreateObject(ToInt(assemblyId),namespaceAndClass));
}
EXPORT char* CALLING_CONVENTION RemoveObjectAsCharPtr(char* objectId)
{
	return ToCharPtr(RemoveObject(ToInt(objectId)));
}

EXPORT char* CALLING_CONVENTION ClearArgumentsAsCharPtr()
{
	return ToCharPtr(ClearArguments());
}
EXPORT char* CALLING_CONVENTION AddStringArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddStringArgument(value));
}
EXPORT char* CALLING_CONVENTION AddCharArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddCharArgument(Convert::ToChar(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddUCharArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddUCharArgument(Convert::ToByte(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddDoubleArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddDoubleArgument(Convert::ToDouble(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddFloatArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddFloatArgument(Convert::ToSingle(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddIntArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddIntArgument(Convert::ToInt32(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddUIntArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddUIntArgument(Convert::ToUInt32(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddShortArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddShortArgument(Convert::ToInt16(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddUShortArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddUShortArgument(Convert::ToUInt16(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddLongArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddLongArgument(Convert::ToInt64(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddULongArgumentAsCharPtr(char* value)
{
	return ToCharPtr(AddULongArgument(Convert::ToUInt64(gcnew String(value))));
}
EXPORT char* CALLING_CONVENTION AddLPVOIDArgumentAsCharPtr(LPVOID value)
{
	return ToCharPtr(AddLPVOIDArgument(value));
}

EXPORT char* CALLING_CONVENTION InvokeStringMethodAsCharPtr(char* objectId, char* methodName)
{
	return InvokeStringMethod(ToInt(objectId), methodName);
}
EXPORT char* CALLING_CONVENTION InvokeCharMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeCharMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeUCharMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeUCharMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeDoubleMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeDoubleMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeFloatMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeFloatMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeIntMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeIntMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeUIntMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeUIntMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeShortMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeShortMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeUShortMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeUShortMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeLongMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeLongMethod(ToInt(objectId), methodName));
}
EXPORT char* CALLING_CONVENTION InvokeULongMethodAsCharPtr(char* objectId, char* methodName)
{
	return ToCharPtr(InvokeULongMethod(ToInt(objectId), methodName));
}
EXPORT LPVOID CALLING_CONVENTION InvokeLPVOIDMethodAsCharPtr(char* objectId, char* methodName)
{
	return InvokeLPVOIDMethod(ToInt(objectId), methodName);
}