//AUTHOR: Utermiko

#using <mscorlib.dll>
#include "stdafx.h"
#include <msclr\marshal.h>
#include "CrossoverManager.h"

#define EXPORT extern "C" __declspec(dllexport)

using namespace System;
using namespace DotNetGMCrossover;

EXPORT double LoadDll(char* path)
{
	return CrossoverManager::LoadDll(gcnew String(path));
}
EXPORT double CreateObject(double assemblyId, char* namespaceAndClass)
{
	return CrossoverManager::CreateObject(assemblyId,gcnew String(namespaceAndClass));
}
EXPORT double RemoveObject(double objectId)
{
	return CrossoverManager::RemoveObject(objectId);
}

EXPORT double AddStringArgument(char* value)
{
	return CrossoverManager::AddStringArgument(gcnew String(value));
}
EXPORT double AddRealArgument(double value)
{
	return CrossoverManager::AddDoubleArgument(value);
}
EXPORT double ClearArguments()
{
	return CrossoverManager::ClearArguments();
}

EXPORT char* StringMethod(double objectId, char* methodName)
{
	return (char*)(void*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(CrossoverManager::InvokeStringMethod(objectId, gcnew String(methodName)));
}
EXPORT double RealMethod(double objectId, char* methodName)
{
	return CrossoverManager::InvokeDoubleMethod(objectId,gcnew String(methodName));
}