#include "stdafx.h"
#include "CrossoverManager.h"

//AUTHOR: Utermiko

using namespace System;
using namespace System::Collections::Generic;
using namespace System::Reflection;

namespace DotNetGMCrossover
{
	double CrossoverManager::LoadDll(String^ path)
	{
		++_assembliesCurrentId;
		try
		{
			_assemblies->Add(_assembliesCurrentId, Assembly::LoadFile(path));
		}
		catch (...) { return -1; }
		return _assembliesCurrentId;
	}
	double CrossoverManager::CreateObject(double assemblyId, String^ namespaceAndClass)
	{
		++_objectsCurrentId;
		try
		{
			_objectsCreated->Add(_objectsCurrentId, _assemblies[assemblyId]->CreateInstance(namespaceAndClass, false, BindingFlags::CreateInstance, nullptr, _arguments->ToArray(), nullptr, gcnew array<Object^>(0)));
		}
		catch (...) { return -1; }
		return _objectsCurrentId;
	}
	double CrossoverManager::RemoveObject(double objectId)
	{
		try
		{
			_objectsCreated->Remove(objectId);
		}
		catch(...){return -1;}
		return 1;
	}

	String^ CrossoverManager::InvokeStringMethod(double objectId, String^ method)
	{
		try
		{
			return (String^)_objectsCreated[objectId]->GetType()->GetMethod(method)->Invoke(_objectsCreated[objectId], _arguments->ToArray());
		}
		catch (...) { return "ERROR"; }
	}
	double CrossoverManager::InvokeDoubleMethod(double objectId, String^ method)
	{
		try
		{
			return (double)_objectsCreated[objectId]->GetType()->GetMethod(method)->Invoke(_objectsCreated[objectId], _arguments->ToArray());
		}
		catch (...) { return -1; }
	}
	double CrossoverManager::AddStringArgument(String^ value)
	{
		try
		{
			_arguments->Add(value);
		}
		catch (...) { return -1; }
		return 1;
	}
	double CrossoverManager::AddDoubleArgument(double value)
	{
		try
		{
			_arguments->Add(value);
		}
		catch (...) { return -1; }
		return 1;
	}

	double CrossoverManager::ClearArguments()
	{
		try
		{
			_arguments->Clear();
		}
		catch (...) { return -1; }
		return 1;
	}
}