#define dotnet_init
//initializes DotNetGMCrossover dll
//argument0 (optional) - path to dll

global.__dotnet_path="DotNetGMCrossover.dll";
if(is_string(argument0)) global.__dotnet_path=argument0;

global.__dotnet_loaddll=external_define(global.__dotnet_path,"LoadDll",dll_stdcall,ty_real,1,ty_string);
global.__dotnet_createobject=external_define(global.__dotnet_path,"CreateObject",dll_stdcall,ty_real,2,ty_real,ty_string);
global.__dotnet_deleteobject=external_define(global.__dotnet_path,"RemoveObject",dll_stdcall,ty_real,1,ty_real);

global.__dotnet_argaddstring=external_define(global.__dotnet_path,"AddStringArgument",dll_stdcall,ty_real,1,ty_string);
global.__dotnet_argaddreal=external_define(global.__dotnet_path,"AddRealArgument",dll_stdcall,ty_real,1,ty_real);
global.__dotnet_argclear=external_define(global.__dotnet_path,"ClearArguments",dll_stdcall,ty_real,0);

global.__dotnet_methodstring=external_define(global.__dotnet_path,"StringMethod",dll_stdcall,ty_string,2,ty_real,ty_string);
global.__dotnet_methodreal=external_define(global.__dotnet_path,"RealMethod",dll_stdcall,ty_real,2,ty_real,ty_string);

#define dotnet_load_dll
//loads managed(.NET) assembly
//argument0 - full path to .NET assembly

return external_call(global.__dotnet_loaddll,argument0);

#define dotnet_create_object
//creates object
//argument0 - assembly id
//argument1 - class (namespace.classname)
//argument2 - number of constructor parametrs (optional)
//argument3... - parametrs(optional)

external_call(global.__dotnet_argclear);
if(is_real(argument2))
{
    for(i=3;i<=argument2+2;i+=1)
    {
        if(is_string(argument[i]))
        {
            external_call(global.__dotnet_argaddstring,argument[i]);
        }
        else
        {
            external_call(global.__dotnet_argaddreal,argument[i]);
        }
    }
}
return external_call(global.__dotnet_createobject,argument0,argument1);

#define dotnet_delete_object
//removes reference of specified object
//WARING: object will remove when Garbage Collector decides on
//argument0 - id of object to remove

return external_call(global.__dotnet_deleteobject,argument0);

#define dotnet_method
//invokes method from specified object
//argument0 - object id
//argument1 - method name
//argument2 - return type (ty_real or ty_string)
//argument3 - arguments count (optional)
//argument4... - arguments (optional)

external_call(global.__dotnet_argclear);
if(is_real(argument3))
{
    for(i=4;i<=argument3+3;i+=1)
    {
        if(is_string(argument[i]))
        {
            external_call(global.__dotnet_argaddstring,argument[i]);
       }
        else
       {
           external_call(global.__dotnet_argaddreal,argument[i]);
       }
}
}
if(argument2==ty_string)
{
     return external_call(global.__dotnet_methodstring,argument0,argument1);  
}
else
{
    return external_call(global.__dotnet_methodreal,argument0,argument1); 
}
return -1;


#define dotnet_free
//unloads dll

external_free(global.__dotnet_path);

